<?php
require_once '../config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'teacher') {
    header('Location: index.php?error=access_denied');
    exit;
}

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT last_name FROM staff WHERE user_id = ?");
$stmt->execute([$user_id]);
$teacher = $stmt->fetch();
$last_name = $teacher ? $teacher['last_name'] : $_SESSION['username'];
$user_id = $_SESSION['user_id'];

// Since teachers are now in staff table, teacher_id is the staff id
$teacher_id = $user_id;

// Fetch statistics for teacher dashboard
// Get total students in teacher's classes
$total_students = $pdo->prepare("
    SELECT COUNT(DISTINCT s.id)
    FROM students s
    JOIN classes c ON s.class = c.name
    JOIN teacher_classes tc ON c.id = tc.class_id
    WHERE tc.teacher_id = ?
");
$total_students->execute([$teacher_id]);
$total_students_count = $total_students->fetchColumn();

// Get total courses assigned to teacher (direct + through classes)
$total_courses = $pdo->prepare("
    SELECT COUNT(DISTINCT course_id) FROM (
        SELECT tc.course_id
        FROM teacher_courses tc
        WHERE tc.teacher_id = ?
        UNION
        SELECT cc.course_id
        FROM class_courses cc
        JOIN classes cl ON cc.class_id = cl.id
        JOIN teacher_classes tcl ON cl.id = tcl.class_id
        WHERE tcl.teacher_id = ?
    ) AS combined_courses
");
$total_courses->execute([$teacher_id, $teacher_id]);
$total_courses_count = $total_courses->fetchColumn();

$total_classes = $pdo->prepare("SELECT COUNT(*) FROM teacher_classes WHERE teacher_id = ?");
$total_classes->execute([$teacher_id]);
$total_classes_count = $total_classes->fetchColumn();

// Get classes assigned to teacher
$stmt = $pdo->prepare("SELECT cl.* FROM classes cl JOIN teacher_classes tc ON cl.id = tc.class_id WHERE tc.teacher_id = ?");
$stmt->execute([$teacher_id]);
$classes = $stmt->fetchAll();

include '../includes/teacher_header.php';
?>

<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>👩‍🏫 Welcome back, <?php echo htmlspecialchars($last_name); ?>!</h1>
        <p class="dashboard-subtitle">Teacher Dashboard - Manage your classes and students</p>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">👨‍🎓</div>
            <div class="stat-content">
                <h3><?php echo $total_students_count; ?></h3>
                <p>Total Students</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">📚</div>
            <div class="stat-content">
                <h3><?php echo $total_courses_count; ?></h3>
                <p>Total Courses</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">🏫</div>
            <div class="stat-content">
                <h3><?php echo $total_classes_count; ?></h3>
                <p>Total Classes</p>
            </div>
        </div>
    </div>

    <!-- Classes List -->
    <div class="classes-list">
        <h2>Your Classes</h2>
        <?php if (count($classes) > 0): ?>
            <div class="classes-grid">
                <?php foreach ($classes as $class): ?>
                    <div class="class-card">
                        <h3><?php echo htmlspecialchars($class['name']); ?></h3>
                        <p><?php echo htmlspecialchars($class['description']); ?></p>
                        <a href="view_students.php?class_id=<?php echo $class['id']; ?>" class="btn btn-primary">View Students</a>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p>You are not assigned to any classes yet.</p>
        <?php endif; ?>
    </div>
</div>

<style>
.dashboard-container {
    padding: 20px;
}

.dashboard-header h1 {
    margin-bottom: 5px;
}

.stats-grid {
    display: flex;
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: #fff;
    border-radius: 8px;
    padding: 20px;
    flex: 1;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    text-align: center;
}

.stat-icon {
    font-size: 2.5em;
    margin-bottom: 10px;
}

.classes-list {
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}

.classes-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill,minmax(250px,1fr));
    gap: 20px;
}

.class-card {
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 15px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.05);
}

.class-card h3 {
    margin-top: 0;
}

.class-card p {
    font-size: 0.9em;
    color: #555;
    margin-bottom: 15px;
}

    .class-card .btn {
        text-decoration: none;
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: white;
        padding: 8px 15px;
        border-radius: 5px;
        font-weight: 600;
        transition: all 0.3s ease;
    }

    .class-card .btn:hover {
        background: linear-gradient(135deg, #2980b9 0%, #2471a3 100%);
    }
</style>

<?php
include '../includes/teacher_footer.php';
?>
