<?php
require_once '../config.php';

if (!in_array($_SESSION['role'], ['admin', 'teacher'])) {
    header('Location: ../dashboard.php');
    exit;
}

// Get teacher's ID
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT id FROM staff WHERE user_id = ? AND role = 'teaching'");
$stmt->execute([$user_id]);
$teacher = $stmt->fetch();

if (!$teacher) {
    die("Teacher not found.");
}

$teacher_id = $teacher['id'];

// Get courses assigned to this teacher with class and term information
$stmt = $pdo->prepare("
    SELECT DISTINCT
        c.id,
        c.name,
        c.code,
        cl.name as class_name,
        t.name as term_name
    FROM teacher_courses tc
    JOIN courses c ON tc.course_id = c.id
    LEFT JOIN class_courses cc ON c.id = cc.course_id
    LEFT JOIN classes cl ON cc.class_id = cl.id
    LEFT JOIN course_terms ct ON c.id = ct.course_id
    LEFT JOIN terms t ON ct.term_id = t.id
    WHERE tc.teacher_id = ?
    ORDER BY c.name, cl.name, t.name
");
$stmt->execute([$teacher_id]);
$assigned_courses = $stmt->fetchAll();

$role = $_SESSION['role'];

if ($role == 'admin') {
    include '../includes/admin_header.php';
} else {
    include '../includes/teacher_header.php';
}
?>

<style>
    .my-courses-container {
        padding: 20px;
        background-color: #f8f9fa;
        min-height: 100vh;
    }

    .page-header {
        background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        text-align: center;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .page-header h2 {
        margin: 0;
        font-size: 2.5em;
        font-weight: 700;
    }

    .courses-section {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        margin-bottom: 30px;
    }

    .courses-section h3 {
        color: #2c3e50;
        margin-bottom: 20px;
        font-size: 1.8em;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }

    th {
        background-color: #27ae60;
        color: white;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    tr:nth-child(even) {
        background-color: #f8f9fa;
    }

    tr:hover {
        background-color: #e8f5e8;
    }

    .no-courses {
        text-align: center;
        color: #6c757d;
        font-size: 1.2em;
        padding: 40px;
    }

    @media (max-width: 768px) {
        table {
            font-size: 0.9em;
        }

        th, td {
            padding: 10px;
        }

        .page-header h2 {
            font-size: 2em;
        }
    }
</style>

<div class="my-courses-container">
    <div class="page-header">
        <h2>📚 My Courses</h2>
    </div>

    <div class="courses-section">
        <h3>My Assigned Courses</h3>

        <?php if (empty($assigned_courses)): ?>
            <div class="no-courses">
                <p>No courses assigned to you yet.</p>
            </div>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>Course Code</th>
                        <th>Course Name</th>
                        <th>Class</th>
                        <th>Term</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($assigned_courses as $course): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($course['code'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($course['name']); ?></td>
                        <td><?php echo htmlspecialchars($course['class_name'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($course['term_name'] ?? 'N/A'); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?php
if ($role == 'admin') {
    include '../includes/admin_footer.php';
} else {
    include '../includes/teacher_footer.php';
}
?>
