<?php
require_once 'config.php';

echo "Payment Method to Cash Account Mappings:\n\n";

$payment_methods = [
    'Cash' => 'Petty Cash',
    'Bank Transfer' => 'Main School Bank Account',
    'Mobile Money' => 'Mobile Money Account',
    'Cheque' => 'Main School Bank Account',
    'Online' => 'Main School Bank Account',
    'Donated' => null // No cash account for donated assets
];

foreach ($payment_methods as $method => $account_name) {
    if ($account_name === null) {
        echo "Payment Method: {$method} -> No cash account (donated assets)\n";
    } else {
        // Get account details from chart_of_accounts
        $stmt = $pdo->prepare("SELECT id, account_code, account_name FROM chart_of_accounts WHERE account_name = ? AND is_active = TRUE");
        $stmt->execute([$account_name]);
        $account = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($account) {
            echo "Payment Method: {$method} -> Account: {$account['account_code']} - {$account['account_name']} (ID: {$account['id']})\n";
        } else {
            echo "Payment Method: {$method} -> Account: {$account_name} (NOT FOUND IN CHART OF ACCOUNTS)\n";
        }
    }
}

echo "\n\nCurrent Chart of Accounts Asset Accounts:\n";
$stmt = $pdo->query("SELECT id, account_code, account_name, current_balance FROM chart_of_accounts WHERE account_type = 'Asset' AND is_active = TRUE ORDER BY account_code");
$assets = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($assets as $asset) {
    echo "ID: {$asset['id']}, Code: {$asset['account_code']}, Name: {$asset['account_name']}, Balance: " . number_format($asset['current_balance'], 2) . "\n";
}
?>
