<?php
require_once 'config.php';

try {
    // Find duplicate parents for student ID 1
    $stmt = $pdo->prepare("
        SELECT full_name, mobile_phone, relationship, COUNT(*) as count
        FROM parents
        WHERE student_id = ?
        GROUP BY full_name, mobile_phone, relationship
        HAVING COUNT(*) > 1
    ");
    $stmt->execute([1]);
    $duplicates = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Duplicate parent records for student ID 1:\n";
    foreach ($duplicates as $dup) {
        echo "- {$dup['full_name']} ({$dup['relationship']}) - {$dup['count']} records\n";
    }

    // Remove duplicate parents, keeping only one record per unique combination
    $stmt = $pdo->prepare("
        DELETE p1 FROM parents p1
        INNER JOIN parents p2
        WHERE p1.student_id = ? AND p2.student_id = ?
        AND p1.id > p2.id
        AND p1.full_name = p2.full_name
        AND p1.mobile_phone = p2.mobile_phone
        AND p1.relationship = p2.relationship
    ");
    $stmt->execute([1, 1]);

    $deleted = $stmt->rowCount();
    echo "\nDeleted $deleted duplicate parent records.\n";

    // Verify remaining parents
    $stmt = $pdo->prepare("SELECT * FROM parents WHERE student_id = ?");
    $stmt->execute([1]);
    $remaining = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "\nRemaining parent records:\n";
    foreach ($remaining as $parent) {
        echo "- ID: {$parent['id']}, Name: {$parent['full_name']}, Phone: {$parent['mobile_phone']}, Relationship: {$parent['relationship']}\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
