<?php
require_once 'config.php';

if (!isset($_GET['student_id']) || !isset($_GET['academic_year_id']) || !isset($_GET['term_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

$student_id = $_GET['student_id'];
$academic_year_id = $_GET['academic_year_id'];
$term_id = $_GET['term_id'];

try {
    // Get courses for this student that have enrollments in the selected academic year and term
    $stmt = $pdo->prepare("
        SELECT DISTINCT c.id, c.code, c.name
        FROM courses c
        JOIN enrollments e ON c.id = e.course_id
        WHERE e.student_id = ? AND e.academic_year_id = ? AND e.term_id = ?
        ORDER BY c.name
    ");
    $stmt->execute([$student_id, $academic_year_id, $term_id]);
    $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $grades = [];
    foreach ($courses as $course) {
        $query = "
            SELECT g.grade, g.comments, g.class_score, g.exam_score, g.final_score
            FROM enrollments e
            LEFT JOIN grades g ON e.id = g.enrollment_id
            WHERE e.student_id = ? AND e.course_id = ? AND e.academic_year_id = ? AND e.term_id = ?
            AND (g.term_id = ? OR g.term_id IS NULL) AND (g.academic_year_id = ? OR g.academic_year_id IS NULL)
        ";
        $stmt = $pdo->prepare($query);
        $stmt->execute([$student_id, $course['id'], $academic_year_id, $term_id, $term_id, $academic_year_id]);
        $grade = $stmt->fetch(PDO::FETCH_ASSOC);

        $grades[] = [
            'course_id' => $course['id'],
            'course_code' => $course['code'],
            'course_name' => $course['name'],
            'class_score' => $grade ? $grade['class_score'] : '',
            'exam_score' => $grade ? $grade['exam_score'] : '',
            'final_score' => $grade ? $grade['final_score'] : '',
            'grade' => $grade ? $grade['grade'] : '',
            'comments' => $grade ? $grade['comments'] : ''
        ];
    }

    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'grades' => $grades
    ]);

} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
