<?php
require_once '../config.php';

// Check if user is logged in and is librarian or admin
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['librarian', 'admin'])) {
    header('Location: ../login.php');
    exit();
}

$page_title = "Library Dashboard";
include '../includes/library_header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <h2><i class="fas fa-tachometer-alt"></i> Library Dashboard</h2>
            <p>Welcome to the Library Management System. Manage books, borrowings, and library resources.</p>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <i class="fas fa-book fa-3x text-primary"></i>
                    <h5 class="card-title mt-3">Total Books</h5>
                    <p class="card-text">
                        <?php
                        try {
                            $stmt = $pdo->query("SELECT COUNT(*) as total FROM library_books");
                            $result = $stmt->fetch(PDO::FETCH_ASSOC);
                            echo $result['total'];
                        } catch (PDOException $e) {
                            echo '0';
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <i class="fas fa-hand-holding fa-3x text-success"></i>
                    <h5 class="card-title mt-3">Books Borrowed</h5>
                    <p class="card-text">
                        <?php
                        try {
                            $stmt = $pdo->query("SELECT COUNT(*) as total FROM library_borrowings WHERE status = 'borrowed'");
                            $result = $stmt->fetch(PDO::FETCH_ASSOC);
                            echo $result['total'];
                        } catch (PDOException $e) {
                            echo '0';
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <i class="fas fa-clock fa-3x text-warning"></i>
                    <h5 class="card-title mt-3">Overdue Books</h5>
                    <p class="card-text">
                        <?php
                        try {
                            $stmt = $pdo->query("SELECT COUNT(*) as total FROM library_borrowings WHERE status IN ('borrowed', 'overdue') AND due_date < CURDATE()");
                            $result = $stmt->fetch(PDO::FETCH_ASSOC);
                            echo $result['total'];
                        } catch (PDOException $e) {
                            echo '0';
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card text-center">
                <div class="card-body">
                    <i class="fas fa-users fa-3x text-info"></i>
                    <h5 class="card-title mt-3">Active Members</h5>
                    <p class="card-text">
                        <?php
                        try {
                            $stmt = $pdo->query("SELECT COUNT(DISTINCT user_id) as total FROM library_borrowings WHERE status = 'borrowed'");
                            $result = $stmt->fetch(PDO::FETCH_ASSOC);
                            echo $result['total'];
                        } catch (PDOException $e) {
                            echo '0';
                        }
                        ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5><i class="fas fa-calendar"></i> Recent Borrowings</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <?php
                        try {
                            $stmt = $pdo->prepare("
                                SELECT lb.*, bk.title,
                                       CASE
                                           WHEN u.role = 'student' THEN s.name
                                           WHEN u.role = 'teacher' THEN t.name
                                           ELSE u.username
                                       END as first_name,
                                       CASE
                                           WHEN u.role = 'student' THEN ''
                                           WHEN u.role = 'teacher' THEN ''
                                           ELSE ''
                                       END as last_name
                                FROM library_borrowings lb
                                JOIN library_books bk ON lb.book_id = bk.id
                                JOIN users u ON lb.user_id = u.id
                                LEFT JOIN students s ON (u.role = 'student' AND s.user_id = u.id)
                                LEFT JOIN teachers t ON (u.role = 'teacher' AND t.user_id = u.id)
                                ORDER BY lb.borrowed_at DESC
                                LIMIT 5
                            ");
                            $stmt->execute();
                            $borrowings = $stmt->fetchAll(PDO::FETCH_ASSOC);

                            if (empty($borrowings)) {
                                echo '<li class="list-group-item">No recent borrowings</li>';
                            } else {
                                foreach ($borrowings as $borrowing) {
                                    echo '<li class="list-group-item">';
                                    echo '<strong>' . htmlspecialchars($borrowing['title']) . '</strong><br>';
                                    echo '<small>Borrowed by: ' . htmlspecialchars($borrowing['first_name'] . ' ' . $borrowing['last_name']) . ' on ' . date('M d, Y', strtotime($borrowing['borrowed_at'])) . '</small>';
                                    echo '</li>';
                                }
                            }
                        } catch (PDOException $e) {
                            echo '<li class="list-group-item">Error loading borrowings</li>';
                        }
                        ?>
                    </ul>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5><i class="fas fa-exclamation-triangle"></i> Overdue Books</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <?php
                        try {
                            $stmt = $pdo->prepare("
                                SELECT lb.*, bk.title,
                                       CASE
                                           WHEN u.role = 'student' THEN s.name
                                           WHEN u.role = 'teacher' THEN t.name
                                           ELSE u.username
                                       END as first_name,
                                       CASE
                                           WHEN u.role = 'student' THEN ''
                                           WHEN u.role = 'teacher' THEN ''
                                           ELSE ''
                                       END as last_name
                                FROM library_borrowings lb
                                JOIN library_books bk ON lb.book_id = bk.id
                                JOIN users u ON lb.user_id = u.id
                                LEFT JOIN students s ON (u.role = 'student' AND s.user_id = u.id)
                                LEFT JOIN teachers t ON (u.role = 'teacher' AND t.user_id = u.id)
                                WHERE lb.status IN ('borrowed', 'overdue') AND lb.due_date < CURDATE()
                                ORDER BY lb.due_date ASC
                                LIMIT 5
                            ");
                            $stmt->execute();
                            $overdue = $stmt->fetchAll(PDO::FETCH_ASSOC);

                            if (empty($overdue)) {
                                echo '<li class="list-group-item">No overdue books</li>';
                            } else {
                                foreach ($overdue as $item) {
                                    echo '<li class="list-group-item">';
                                    echo '<strong>' . htmlspecialchars($item['title']) . '</strong><br>';
                                    echo '<small>By: ' . htmlspecialchars($item['first_name'] . ' ' . $item['last_name']) . ' - Due: ' . date('M d, Y', strtotime($item['due_date'])) . '</small>';
                                    echo '</li>';
                                }
                            }
                        } catch (PDOException $e) {
                            echo '<li class="list-group-item">Error loading overdue books</li>';
                        }
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/library_footer.php'; ?>
