<?php
require_once 'config.php';

// Redirect to login page always (dashboard.php does not exist)
header('Location: login.php');
exit;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }

        header {
            background-color: #333;
            color: #fff;
            padding: 10px 0;
            text-align: center;
        }

        header h1 {
            margin-bottom: 10px;
        }

        main {
            background-color: #fff;
            padding: 20px;
            margin: 20px 0;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }

        .welcome-section {
            text-align: center;
        }

        .welcome-section h2 {
            margin-bottom: 20px;
            color: #2c3e50;
        }

        .welcome-section p {
            margin-bottom: 30px;
            color: #7f8c8d;
        }

        .features {
            display: flex;
            justify-content: space-around;
            margin: 20px 0;
        }

        .feature {
            flex: 1;
            margin: 0 10px;
            padding: 20px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }

        .feature h3 {
            margin-bottom: 10px;
            color: #333;
        }

        .feature ul {
            list-style: none;
            padding: 0;
        }

        .feature li {
            margin-bottom: 5px;
        }

        .btn {
            display: inline-block;
            padding: 10px 20px;
            background-color: #333;
            color: #fff;
            text-decoration: none;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        .btn-primary {
            background-color: #007bff;
        }

        footer {
            text-align: center;
            padding: 10px 0;
            background-color: #333;
            color: #fff;
            position: fixed;
            bottom: 0;
            width: 100%;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .features {
                flex-direction: column;
            }

            .feature {
                margin: 10px 0;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>Welcome to School Management System</h1>
        </header>

        <main>
            <div class="welcome-section">
                <h2>Manage Your School Efficiently</h2>
                <p>This system allows administrators, teachers, and students to manage school operations seamlessly.</p>

                <div class="features">
                    <div class="feature">
                        <h3>For Administrators</h3>
                        <ul>
                            <li>Manage students and teachers</li>
                            <li>Create and assign courses</li>
                            <li>View system reports</li>
                        </ul>
                    </div>

                    <div class="feature">
                        <h3>For Teachers</h3>
                        <ul>
                            <li>View enrolled students</li>
                            <li>Assign grades</li>
                            <li>Manage course information</li>
                        </ul>
                    </div>

                    <div class="feature">
                        <h3>For Students</h3>
                        <ul>
                            <li>View personal profile</li>
                            <li>Check grades</li>
                            <li>Access course information</li>
                        </ul>
                    </div>
                </div>

                <a href="login.php" class="btn btn-primary">Login to System</a>
            </div>
        </main>

        <footer>
            <p>&copy; 2024 School Management System. All rights reserved.</p>
        </footer>
    </div>

    <script src="/school/js/script.js"></script>
</body>
</html>
