<style>
    .student-sidebar {
        width: 280px;
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: #fff;
        padding: 0;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        z-index: 1000;
        font-size: 0.85rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        transition: all 0.3s ease;
    }

    .sidebar-header {
        padding: 25px 20px 15px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        background: rgba(255,255,255,0.05);
    }

    .student-sidebar h3 {
        margin: 0;
        color: #fff;
        font-size: 1.3em;
        font-weight: 700;
        text-align: center;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        animation: fadeInDown 0.8s ease forwards;
    }

    .sidebar-menu {
        list-style: none;
        padding: 15px 0;
        margin: 0;
    }

    .menu-item {
        margin-bottom: 5px;
    }

    .menu-link {
        color: #ecf0f1;
        text-decoration: none;
        display: flex;
        align-items: center;
        padding: 15px 20px;
        border-radius: 0;
        transition: all 0.3s ease;
        position: relative;
        border-left: 4px solid transparent;
    }

    .menu-link:hover {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        border-left-color: #f39c12;
        text-decoration: none;
    }

    .menu-link.active {
        background-color: rgba(255,255,255,0.15);
        border-left-color: #f39c12;
    }

    .menu-icon {
        font-size: 1.2em;
        margin-right: 15px;
        width: 25px;
        text-align: center;
        display: inline-block;
    }

    .menu-text {
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .logout-item .menu-link {
        margin-top: 20px;
        border-top: 1px solid rgba(255,255,255,0.1);
        padding-top: 20px;
    }

    .logout-item .menu-link:hover {
        background-color: rgba(231, 76, 60, 0.8);
        border-left-color: #e74c3c;
    }

    /* Keyframes for animations */
    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .student-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s ease;
            z-index: 1100;
            width: 260px;
            box-shadow: 2px 0 20px rgba(0,0,0,0.3);
        }

        .student-sidebar.open {
            transform: translateX(0);
        }

        .sidebar-header {
            padding: 20px 15px 10px;
        }

        .student-sidebar h3 {
            font-size: 1.1em;
        }

        .menu-link {
            padding: 12px 15px;
        }

        .menu-icon {
            font-size: 1.1em;
            margin-right: 12px;
            width: 20px;
        }

        .menu-text {
            font-size: 0.9em;
        }

        /* Overlay for mobile */
        .student-sidebar::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: -1;
        }

        .student-sidebar.open::before {
            opacity: 1;
            visibility: visible;
        }
    }

    @media (max-width: 480px) {
        .student-sidebar {
            width: 240px;
        }

        .sidebar-header {
            padding: 15px 10px 8px;
        }

        .student-sidebar h3 {
            font-size: 1em;
        }

        .menu-link {
            padding: 10px 12px;
        }

        .menu-icon {
            font-size: 1em;
            margin-right: 10px;
            width: 18px;
        }

        .menu-text {
            font-size: 0.85em;
        }
    }
</style>

<div class="student-sidebar">
    <div class="sidebar-header">
        <h3>🎓 Student Panel</h3>
    </div>
    <ul class="sidebar-menu">
        <li class="menu-item">
            <a href="student_dashboard.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'student_dashboard.php' ? 'active' : ''; ?>">
                <span class="menu-icon">📊</span>
                <span class="menu-text">Dashboard</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="view_grades.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_grades.php' ? 'active' : ''; ?>">
                <span class="menu-icon">📝</span>
                <span class="menu-text">My Grades</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="view_profile.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_profile.php' ? 'active' : ''; ?>">
                <span class="menu-icon">👤</span>
                <span class="menu-text">My Profile</span>
            </a>
        </li>

        <li class="menu-item">
            <a href="#" class="menu-link">
                <span class="menu-icon">📅</span>
                <span class="menu-text">Schedule</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="fees_payments.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'fees_payments.php' ? 'active' : ''; ?>">
                <span class="menu-icon">💰</span>
                <span class="menu-text">Fees & Payments</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="view_attendance.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_attendance.php' ? 'active' : ''; ?>">
                <span class="menu-icon">📋</span>
                <span class="menu-text">Attendance</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="#" class="menu-link">
                <span class="menu-icon">📖</span>
                <span class="menu-text">Assignments</span>
            </a>
        </li>
        <li class="menu-item logout-item">
            <a href="../logout.php" class="menu-link">
                <span class="menu-icon">🚪</span>
                <span class="menu-text">Logout</span>
            </a>
        </li>
    </ul>
</div>


