<?php
require_once 'config.php';
require_once 'auto_enroll_students.php';

echo "Finding students not enrolled in any courses for the current academic year and term...\n";

// Get active academic year and term
$active_year = $pdo->query("SELECT id FROM academic_years WHERE is_active = 1 LIMIT 1")->fetch();
$academic_year_id = $active_year ? $active_year['id'] : null;

$active_term = $pdo->query("SELECT id FROM terms WHERE is_active = 1 LIMIT 1")->fetch();
$term_id = $active_term ? $active_term['id'] : null;

if (!$academic_year_id) {
    echo "No active academic year found. Please set an active academic year.\n";
    exit;
}

echo "Active Academic Year ID: $academic_year_id\n";
echo "Active Term ID: " . ($term_id ?: 'None') . "\n\n";

// Find students not enrolled in any courses for the current academic year and term
$query = "
    SELECT s.id, s.first_name, s.middle_name, s.last_name, s.class
    FROM students s
    WHERE NOT EXISTS (
        SELECT 1 FROM enrollments e
        WHERE e.student_id = s.id
        AND e.academic_year_id = ?
        AND (e.term_id = ? OR ? IS NULL)
    )
    ORDER BY s.class, s.first_name, s.last_name
";

$stmt = $pdo->prepare($query);
$stmt->execute([$academic_year_id, $term_id, $term_id]);
$unenrolled_students = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($unenrolled_students)) {
    echo "All students are enrolled in courses for the current academic year and term.\n";
    exit;
}

echo "Found " . count($unenrolled_students) . " unenrolled students:\n\n";

$total_enrolled = 0;
foreach ($unenrolled_students as $student) {
    $student_name = trim($student['first_name'] . ' ' . ($student['middle_name'] ?: '') . ' ' . $student['last_name']);
    echo "Student: $student_name (ID: {$student['id']}, Class: {$student['class']})\n";

    // Auto-enroll this student
    $enrollment_result = autoEnrollStudent($student['id'], $student['class']);

    if ($enrollment_result['success']) {
        echo "  ✓ Enrolled successfully: {$enrollment_result['message']}\n";
        // Extract the number from the message (e.g., "3 new enrollments created")
        if (preg_match('/(\d+) new enrollments created/', $enrollment_result['message'], $matches)) {
            $total_enrolled += intval($matches[1]);
        }
    } else {
        echo "  ✗ Enrollment failed: {$enrollment_result['message']}\n";
    }
    echo "\n";
}

echo "Enrollment process complete!\n";
echo "Total new enrollments created: $total_enrolled\n";
?>
