<?php
require_once 'config.php';

$student_id = 1; // David Yaw
$academic_year_id = 2; // 2026-2027
$term_id = null; // No active term

// Courses to enroll: J1 level (IDs 1, 2, 3)
$courses_to_enroll = [1, 2, 3]; // Mathematic J1, English Language J1, Information & com. Tech J1

echo "Enrolling student ID $student_id in courses for academic year $academic_year_id\n";

foreach ($courses_to_enroll as $course_id) {
    // Check if already enrolled
    $check = $pdo->prepare('SELECT id FROM enrollments WHERE student_id = ? AND course_id = ? AND academic_year_id = ?');
    $check->execute([$student_id, $course_id, $academic_year_id]);
    $existing = $check->fetch();

    if ($existing) {
        echo "Already enrolled in course $course_id\n";
        continue;
    }

    // Enroll
    $insert = $pdo->prepare('INSERT INTO enrollments (student_id, course_id, academic_year_id, term_id, enrolled_at) VALUES (?, ?, ?, ?, NOW())');
    $insert->execute([$student_id, $course_id, $academic_year_id, $term_id]);
    echo "Enrolled in course $course_id\n";
}

echo "Enrollment complete!\n";
?>
