<?php
require_once 'config.php';

try {
    // Check if student_users table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'student_users'");
    $student_users_exists = $stmt->fetch();

    if (!$student_users_exists) {
        echo "Error: student_users table does not exist. Cannot drop users table.\n";
        exit;
    }

    // Check if users table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'users'");
    $users_exists = $stmt->fetch();

    if (!$users_exists) {
        echo "users table does not exist.\n";
        exit;
    }

    // Check for any references to users table that might prevent dropping
    $stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role != 'student'");
    $non_student_users = $stmt->fetchColumn();

    if ($non_student_users > 0) {
        echo "Warning: There are $non_student_users non-student users in the users table.\n";
        echo "These users will be lost when the table is dropped.\n";
        echo "Consider migrating them to appropriate tables first.\n";
    }

    // Drop the users table
    $pdo->exec("DROP TABLE users");

    echo "users table has been dropped successfully.\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
