<?php
require_once 'config.php';
try {
    // Check staff_accounts table
    echo "=== STAFF_ACCOUNTS TABLE ===\n";
    $stmt = $pdo->query('SELECT id, username, status FROM staff_accounts LIMIT 10');
    while ($row = $stmt->fetch()) {
        echo "ID: {$row['id']}, Username: {$row['username']}, Status: {$row['status']}\n";
    }

    echo "\n=== STAFF TABLE ===\n";
    $stmt = $pdo->query('SELECT user_id, first_name, last_name, role FROM staff LIMIT 10');
    while ($row = $stmt->fetch()) {
        echo "User_ID: {$row['user_id']}, Name: {$row['first_name']} {$row['last_name']}, Role: {$row['role']}\n";
    }

    echo "\n=== ALL STAFF RECORDS ===\n";
    $stmt = $pdo->query('SELECT * FROM staff');
    while ($row = $stmt->fetch()) {
        echo "ID: {$row['id']}, User_ID: {$row['user_id']}, Name: {$row['first_name']} {$row['last_name']}, Role: {$row['role']}\n";
    }

    echo "\n=== ALL STAFF_ACCOUNTS RECORDS ===\n";
    $stmt = $pdo->query('SELECT * FROM staff_accounts');
    while ($row = $stmt->fetch()) {
        echo "ID: {$row['id']}, Username: {$row['username']}, Status: {$row['status']}\n";
    }

    echo "\n=== JOINED QUERY ===\n";
    $stmt = $pdo->prepare("
        SELECT su.id, su.username, su.status, s.role, s.first_name, s.last_name
        FROM staff_accounts su
        LEFT JOIN staff s ON su.id = s.user_id
    ");
    $stmt->execute();
    while ($row = $stmt->fetch()) {
        echo "ID: {$row['id']}, Username: {$row['username']}, Name: {$row['first_name']} {$row['last_name']}, Role: {$row['role']}, Status: {$row['status']}\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
