<?php
session_start();
require_once '../config.php';
require_once '../includes/enhanced_access_control_fixed.php';

// Check if user is logged in and is a teacher
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'teacher') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

header('Content-Type: application/json');

$payslip_id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if (!$payslip_id) {
    echo json_encode(['success' => false, 'message' => 'Invalid payslip ID']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT p.*, pr.payroll_month, pr.payroll_year,
               CONCAT(s.first_name, ' ', s.last_name) as teacher_name,
               s.staff_id,
               pr.processed_at,
               COALESCE(JSON_OBJECTAGG(LOWER(COALESCE(at.name, 'other')), sa.amount), '{}') as allowances
        FROM payslips p
        JOIN payroll_runs pr ON p.payroll_run_id = pr.id
        LEFT JOIN staff s ON p.staff_id = s.staff_id
        LEFT JOIN salary_structures ss ON s.staff_id = ss.staff_id AND ss.is_active = TRUE
        LEFT JOIN staff_allowances sa ON ss.id = sa.salary_structure_id
        LEFT JOIN allowance_types at ON sa.allowance_type_id = at.id
        WHERE p.id = ? AND s.id = ?
        GROUP BY p.id, pr.payroll_month, pr.payroll_year, pr.processed_at, s.first_name, s.last_name, s.staff_id
    ");
    $stmt->execute([$payslip_id, $_SESSION['user_id']]);
    $payslip = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$payslip) {
        echo json_encode(['success' => false, 'message' => 'Payslip not found']);
        exit;
    }

    echo json_encode(['success' => true, 'payslip' => $payslip]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
