<?php
require_once '../config.php';

if (!isset($_SESSION['receipt_data'])) {
    header('Location: record_payments.php');
    exit;
}

$receipt = $_SESSION['receipt_data'];
unset($_SESSION['receipt_data']); // Clear session data after use
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt - <?php echo htmlspecialchars($receipt['receipt_number']); ?></title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            background: #f5f5f5;
        }

        .receipt-container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            overflow: hidden;
        }

        .receipt-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }

        .receipt-header h1 {
            margin: 0;
            font-size: 2.5em;
            font-weight: 700;
        }

        .receipt-header p {
            margin: 10px 0 0;
            opacity: 0.9;
            font-size: 1.1em;
        }

        .receipt-body {
            padding: 40px;
        }

        .receipt-number {
            text-align: center;
            font-size: 1.5em;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 30px;
            border-bottom: 2px solid #eee;
            padding-bottom: 20px;
        }

        .receipt-details {
            margin-bottom: 30px;
        }

        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding: 10px 0;
            border-bottom: 1px solid #f0f0f0;
        }

        .detail-label {
            font-weight: 600;
            color: #555;
        }

        .detail-value {
            color: #333;
        }

        .amount-highlight {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            margin: 30px 0;
            border: 2px solid #667eea;
        }

        .amount-highlight .amount {
            font-size: 2em;
            font-weight: bold;
            color: #667eea;
        }

        .receipt-footer {
            background: #f8f9fa;
            padding: 30px;
            text-align: center;
            border-top: 1px solid #e9ecef;
        }

        .receipt-footer p {
            margin: 5px 0;
            color: #6c757d;
        }

        .print-button {
            background: #28a745;
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 25px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            margin: 20px;
            transition: all 0.3s ease;
        }

        .print-button:hover {
            background: #218838;
            transform: translateY(-2px);
        }

        @media print {
            body {
                background: white;
            }

            .receipt-container {
                box-shadow: none;
                border: 1px solid #ddd;
            }

            .print-button {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="receipt-header">
            <h1>School Management System</h1>
            <p>Payment Receipt</p>
        </div>

        <div class="receipt-body">
            <div class="receipt-number">
                Receipt #<?php echo htmlspecialchars($receipt['receipt_number']); ?>
            </div>

            <div class="receipt-details">
                <div class="detail-row">
                    <span class="detail-label">Student Name:</span>
                    <span class="detail-value"><?php echo htmlspecialchars($receipt['student_name']); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Fee Description:</span>
                    <span class="detail-value"><?php echo htmlspecialchars($receipt['fee_name']); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Payment Method:</span>
                    <span class="detail-value"><?php echo htmlspecialchars($receipt['payment_method']); ?></span>
                </div>

                <div class="detail-row">
                    <span class="detail-label">Payment Date:</span>
                    <span class="detail-value"><?php echo date('F j, Y', strtotime($receipt['payment_date'])); ?></span>
                </div>
            </div>

            <div class="amount-highlight">
                <div class="amount-label">Amount Paid</div>
                <div class="amount">GHC <?php echo number_format($receipt['amount'], 2); ?></div>
            </div>
        </div>

        <div class="receipt-footer">
            <p><strong>Thank you for your payment!</strong></p>
            <p>This receipt was generated on <?php echo date('F j, Y \a\t g:i A'); ?></p>
            <p>Please keep this receipt for your records.</p>
        </div>
    </div>

    <div style="text-align: center; margin-top: 20px;">
        <button class="print-button" onclick="window.print()">Print Receipt</button>
        <button class="print-button" onclick="window.close()" style="background: #6c757d;">Close</button>
    </div>

    <script>
        // Auto-print when page loads (optional)
        // window.onload = function() {
        //     window.print();
        // };
    </script>
</body>
</html>
