<?php
require_once '../config.php';

$message = '';

// Create table for student login info if not exists
$pdo->exec("CREATE TABLE IF NOT EXISTS student_logins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    student_id INT NOT NULL,
    login_time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    ip_address VARCHAR(45),
    user_agent VARCHAR(255),
    FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE
)");

// Handle form submission to add a login record manually (optional)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_login'])) {
    $student_id = $_POST['student_id'];
    $ip_address = $_POST['ip_address'] ?? '';
    $user_agent = $_POST['user_agent'] ?? '';

    $stmt = $pdo->prepare("INSERT INTO student_logins (student_id, ip_address, user_agent) VALUES (?, ?, ?)");
    $stmt->execute([$student_id, $ip_address, $user_agent]);

    $message = 'Login record added successfully.';
}

// Fetch all login records with student info
$stmt = $pdo->query("SELECT sl.*, s.name FROM student_logins sl JOIN students s ON sl.student_id = s.id ORDER BY sl.login_time DESC");
$logins = $stmt->fetchAll();

include '../includes/admin_header.php';
?>

<h2>Student Login Records</h2>

<?php if ($message): ?>
    <div class="message success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Student Name</th>
            <th>Login Time</th>
            <th>IP Address</th>
            <th>User Agent</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($logins as $login): ?>
            <tr>
                <td><?php echo $login['id']; ?></td>
                <td><?php echo htmlspecialchars($login['name']); ?></td>
                <td><?php echo $login['login_time']; ?></td>
                <td><?php echo htmlspecialchars($login['ip_address']); ?></td>
                <td><?php echo htmlspecialchars($login['user_agent']); ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
include '../includes/admin_footer.php';
?>
