<?php
require_once '../config.php';
require_once '../includes/access_control.php';

requireFeatureAccess('librarian_management');

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_librarian'])) {
        $username = trim($_POST['username']);
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $first_name = trim($_POST['first_name']);
        $middle_name = trim($_POST['middle_name']);
        $last_name = trim($_POST['last_name']);
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $address = trim($_POST['address']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $qualification = trim($_POST['qualification']);
        $job_position = trim($_POST['job_position']);
        $staff_rank = trim($_POST['staff_rank']);
        $salary = $_POST['salary'];
        $hire_date = $_POST['hire_date'];

        // Insert user
        $stmt = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, 'librarian')");
        $stmt->execute([$username, $password]);
        $user_id = $pdo->lastInsertId();

        // Insert librarian
        $stmt = $pdo->prepare("INSERT INTO librarians (user_id, first_name, middle_name, last_name, dob, gender, address, email, phone, qualification, job_position, staff_rank, salary, hire_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$user_id, $first_name, $middle_name, $last_name, $dob, $gender, $address, $email, $phone, $qualification, $job_position, $staff_rank, $salary, $hire_date]);

        $message = 'Librarian added successfully.';
    } elseif (isset($_POST['edit_librarian'])) {
        $librarian_id = $_POST['librarian_id'];
        $first_name = trim($_POST['first_name']);
        $middle_name = trim($_POST['middle_name']);
        $last_name = trim($_POST['last_name']);
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $address = trim($_POST['address']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $qualification = trim($_POST['qualification']);
        $job_position = trim($_POST['job_position']);
        $staff_rank = trim($_POST['staff_rank']);
        $salary = $_POST['salary'];
        $hire_date = $_POST['hire_date'];

        $stmt = $pdo->prepare("UPDATE librarians SET first_name = ?, middle_name = ?, last_name = ?, dob = ?, gender = ?, address = ?, email = ?, phone = ?, qualification = ?, job_position = ?, staff_rank = ?, salary = ?, hire_date = ? WHERE id = ?");
        $stmt->execute([$first_name, $middle_name, $last_name, $dob, $gender, $address, $email, $phone, $qualification, $job_position, $staff_rank, $salary, $hire_date, $librarian_id]);

        $message = 'Librarian updated successfully.';
    } elseif (isset($_POST['delete_librarian'])) {
        $librarian_id = $_POST['librarian_id'];

        // Delete librarian (cascade will delete user)
        $stmt = $pdo->prepare("DELETE FROM librarians WHERE id = ?");
        $stmt->execute([$librarian_id]);

        $message = 'Librarian deleted successfully.';
    }
}

// Get all librarians
$stmt = $pdo->query("SELECT l.*, u.username FROM librarians l JOIN users u ON l.user_id = u.id");
$librarians = $stmt->fetchAll();

// Get librarian for edit
$edit_librarian = null;
if (isset($_GET['edit'])) {
    $librarian_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT l.*, u.username FROM librarians l JOIN users u ON l.user_id = u.id WHERE l.id = ?");
    $stmt->execute([$librarian_id]);
    $edit_librarian = $stmt->fetch();
}

include '../includes/admin_header.php';
?>

<style>
.form-row {
    display: flex;
    gap: 20px;
    margin-bottom: 15px;
}
.form-row .form-group {
    flex: 1;
}
.form-row .form-group:last-child {
    margin-bottom: 0;
}
fieldset {
    margin-bottom: 20px;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 15px;
}
legend {
    font-weight: bold;
    color: #333;
}

.librarians-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.librarians-table table {
    width: 100%;
    border-collapse: collapse;
}

.librarians-table th,
.librarians-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.librarians-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.librarians-table tr:hover {
    background: #f8f9fa;
}
</style>

<h2>Manage Librarians</h2>

<?php if ($message): ?>
    <div class="message"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if ($edit_librarian): ?>
    <h3>Edit Librarian</h3>

    <form method="post" action="manage_librarians.php">
        <input type="hidden" name="librarian_id" value="<?php echo $edit_librarian['id']; ?>">

        <fieldset>
            <legend>Login Credentials</legend>
            <div class="form-row">
                <div class="form-group">
                    <label for="username">👤 Username:</label>
                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($edit_librarian['username'] ?? ''); ?>" required>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <legend>Bio Information</legend>
            <div class="form-row">
                <div class="form-group">
                    <label for="first_name">👤 First Name:</label>
                    <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($edit_librarian['first_name'] ?? ''); ?>" required>
                </div>
                <div class="form-group">
                    <label for="middle_name">👤 Middle Name:</label>
                    <input type="text" id="middle_name" name="middle_name" value="<?php echo htmlspecialchars($edit_librarian['middle_name'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="last_name">👤 Last Name:</label>
                    <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($edit_librarian['last_name'] ?? ''); ?>" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="dob">📅 Date of Birth:</label>
                    <input type="date" id="dob" name="dob" value="<?php echo htmlspecialchars($edit_librarian['dob'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="gender">⚧ Gender:</label>
                    <select id="gender" name="gender">
                        <option value="">Select Gender</option>
                        <option value="male" <?php echo ($edit_librarian['gender'] ?? '') == 'male' ? 'selected' : ''; ?>>Male</option>
                        <option value="female" <?php echo ($edit_librarian['gender'] ?? '') == 'female' ? 'selected' : ''; ?>>Female</option>
                        <option value="other" <?php echo ($edit_librarian['gender'] ?? '') == 'other' ? 'selected' : ''; ?>>Other</option>
                    </select>
                </div>
            </div>
        </fieldset>

        <fieldset>
            <legend>Contact Information</legend>
            <div class="form-group">
                <label for="address">🏠 Address:</label>
                <textarea id="address" name="address"><?php echo htmlspecialchars($edit_librarian['address'] ?? ''); ?></textarea>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="email">📧 Email:</label>
                    <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($edit_librarian['email'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="phone">📞 Phone:</label>
                    <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($edit_librarian['phone'] ?? ''); ?>">
                </div>
            </div>
            <div class="form-group">
                <label for="qualification">🎓 Qualification:</label>
                <input type="text" id="qualification" name="qualification" value="<?php echo htmlspecialchars($edit_librarian['qualification'] ?? ''); ?>">
            </div>
        </fieldset>

        <fieldset>
            <legend>Professional Information</legend>
            <div class="form-row">
                <div class="form-group">
                    <label for="job_position">💼 Position:</label>
                    <input type="text" id="job_position" name="job_position" value="<?php echo htmlspecialchars($edit_librarian['job_position'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="staff_rank">🏆 Rank:</label>
                    <input type="text" id="staff_rank" name="staff_rank" value="<?php echo htmlspecialchars($edit_librarian['staff_rank'] ?? ''); ?>">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="salary">💰 Salary:</label>
                    <input type="number" step="0.01" id="salary" name="salary" value="<?php echo htmlspecialchars($edit_librarian['salary'] ?? ''); ?>">
                </div>
                <div class="form-group">
                    <label for="hire_date">📅 Hire Date:</label>
                    <input type="date" id="hire_date" name="hire_date" value="<?php echo htmlspecialchars($edit_librarian['hire_date'] ?? ''); ?>">
                </div>
            </div>
        </fieldset>

        <button type="submit" name="edit_librarian" class="btn btn-primary">Update Librarian</button>
        <a href="manage_librarians.php" class="btn">Cancel</a>
    </form>
<?php else: ?>
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addLibrarianModal">Add New Librarian</button>
<?php endif; ?>

<h3>All Librarians</h3>

<table class="librarians-table">
    <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Position</th>
            <th>Gender</th>
            <th>Rank</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($librarians as $librarian): ?>
            <tr>
                <td><?php echo $librarian['id']; ?></td>
                <td><?php echo htmlspecialchars(trim($librarian['first_name'] . ' ' . $librarian['middle_name'] . ' ' . $librarian['last_name'])); ?></td>
                <td><?php echo htmlspecialchars($librarian['job_position']); ?></td>
                <td><?php echo htmlspecialchars($librarian['gender']); ?></td>
                <td><?php echo htmlspecialchars($librarian['staff_rank']); ?></td>
                <td><?php echo htmlspecialchars($librarian['phone']); ?></td>
                <td><?php echo htmlspecialchars($librarian['email']); ?></td>
                <td>
                    <a href="?edit=<?php echo $librarian['id']; ?>" class="btn btn-small">Edit</a>
                    <form method="post" action="manage_librarians.php" style="display:inline;">
                        <input type="hidden" name="librarian_id" value="<?php echo $librarian['id']; ?>">
                        <button type="submit" name="delete_librarian" class="btn btn-small btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Add Librarian Modal -->
<div class="modal fade" id="addLibrarianModal" tabindex="-1" role="dialog" aria-labelledby="addLibrarianModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addLibrarianModalLabel">Add New Librarian</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" action="manage_librarians.php" id="addLibrarianForm">
                    <fieldset>
                        <legend>Login Credentials</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="username">👤 Username:</label>
                                <input type="text" id="username" name="username" required>
                            </div>
                            <div class="form-group">
                                <label for="password">🔒 Password:</label>
                                <input type="password" id="password" name="password" required>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Bio Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="first_name">👤 First Name:</label>
                                <input type="text" id="first_name" name="first_name" required>
                            </div>
                            <div class="form-group">
                                <label for="middle_name">👤 Middle Name:</label>
                                <input type="text" id="middle_name" name="middle_name">
                            </div>
                            <div class="form-group">
                                <label for="last_name">👤 Last Name:</label>
                                <input type="text" id="last_name" name="last_name" required>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="dob">📅 Date of Birth:</label>
                                <input type="date" id="dob" name="dob">
                            </div>
                            <div class="form-group">
                                <label for="gender">⚧ Gender:</label>
                                <select id="gender" name="gender">
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Contact Information</legend>
                        <div class="form-group">
                            <label for="address">🏠 Address:</label>
                            <textarea id="address" name="address"></textarea>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="email">📧 Email:</label>
                                <input type="email" id="email" name="email">
                            </div>
                            <div class="form-group">
                                <label for="phone">📞 Phone:</label>
                                <input type="text" id="phone" name="phone">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="qualification">🎓 Qualification:</label>
                            <input type="text" id="qualification" name="qualification">
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Professional Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="job_position">💼 Position:</label>
                                <input type="text" id="job_position" name="job_position">
                            </div>
                            <div class="form-group">
                                <label for="staff_rank">🏆 Rank:</label>
                                <input type="text" id="staff_rank" name="staff_rank">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="salary">💰 Salary:</label>
                                <input type="number" step="0.01" id="salary" name="salary">
                            </div>
                            <div class="form-group">
                                <label for="hire_date">📅 Hire Date:</label>
                                <input type="date" id="hire_date" name="hire_date">
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="submit" form="addLibrarianForm" name="add_librarian" class="btn btn-primary">Add Librarian</button>
            </div>
        </div>
    </div>
</div>

<?php
include '../includes/admin_footer.php';
?>
