<?php
require_once '../config.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_course'])) {
        $code = trim($_POST['code']);
        $name = trim($_POST['name']);
        $selected_terms = $_POST['terms'] ?? [];
        $description = trim($_POST['description']);
        $selected_classes = $_POST['classes'] ?? [];

        $stmt = $pdo->prepare("INSERT INTO courses (code, name, description) VALUES (?, ?, ?)");
        $stmt->execute([$code, $name, $description]);
        $new_course_id = $pdo->lastInsertId();

        // Assign course to selected terms
        foreach ($selected_terms as $term_id) {
            // Check if assignment already exists
            $stmt = $pdo->prepare("SELECT id FROM course_terms WHERE course_id = ? AND term_id = ?");
            $stmt->execute([$new_course_id, $term_id]);
            $existing = $stmt->fetch();

            if (!$existing) {
                $stmt = $pdo->prepare("INSERT INTO course_terms (course_id, term_id) VALUES (?, ?)");
                $stmt->execute([$new_course_id, $term_id]);
            }
        }

        // Assign course to selected classes
        foreach ($selected_classes as $class_id) {
            // Check if assignment already exists
            $stmt = $pdo->prepare("SELECT id FROM class_courses WHERE class_id = ? AND course_id = ?");
            $stmt->execute([$class_id, $new_course_id]);
            $existing = $stmt->fetch();

            if (!$existing) {
                $stmt = $pdo->prepare("INSERT INTO class_courses (class_id, course_id) VALUES (?, ?)");
                $stmt->execute([$class_id, $new_course_id]);
            }
        }

        $message = 'Course added successfully.';
    } elseif (isset($_POST['edit_course'])) {
        $course_id = $_POST['course_id'];
        $code = trim($_POST['code']);
        $name = trim($_POST['name']);
        $selected_terms = $_POST['terms'] ?? [];
        $description = trim($_POST['description']);
        $selected_classes = $_POST['classes'] ?? [];

        $stmt = $pdo->prepare("UPDATE courses SET code = ?, name = ?, description = ? WHERE id = ?");
        $stmt->execute([$code, $name, $description, $course_id]);

        // Update course_terms assignments
        // First, remove all existing assignments for this course
        $stmt = $pdo->prepare("DELETE FROM course_terms WHERE course_id = ?");
        $stmt->execute([$course_id]);

        // Then assign the selected terms
        foreach ($selected_terms as $term_id) {
            $stmt = $pdo->prepare("INSERT INTO course_terms (course_id, term_id) VALUES (?, ?)");
            $stmt->execute([$course_id, $term_id]);
        }

        // Update class_courses assignments
        // First, remove all existing assignments for this course
        $stmt = $pdo->prepare("DELETE FROM class_courses WHERE course_id = ?");
        $stmt->execute([$course_id]);

        // Then assign the selected classes
        foreach ($selected_classes as $class_id) {
            $stmt = $pdo->prepare("INSERT INTO class_courses (class_id, course_id) VALUES (?, ?)");
            $stmt->execute([$class_id, $course_id]);
        }

        $message = 'Course updated successfully.';
    } elseif (isset($_POST['delete_course'])) {
        $course_id = $_POST['course_id'];

        $stmt = $pdo->prepare("DELETE FROM courses WHERE id = ?");
        $stmt->execute([$course_id]);

        $message = 'Course deleted successfully.';
    }
}

// Get all courses with class names and term information
$stmt = $pdo->query("SELECT c.*, GROUP_CONCAT(DISTINCT cl.name SEPARATOR ', ') as class_names, GROUP_CONCAT(DISTINCT t.name SEPARATOR ', ') as term_names FROM courses c LEFT JOIN class_courses cc ON c.id = cc.course_id LEFT JOIN classes cl ON cc.class_id = cl.id LEFT JOIN course_terms ct ON c.id = ct.course_id LEFT JOIN terms t ON ct.term_id = t.id GROUP BY c.id");
$courses = $stmt->fetchAll();

// Get all classes for dropdown
$stmt = $pdo->query("SELECT id, name FROM classes ORDER BY name");
$classes = $stmt->fetchAll();

// Get all terms for dropdown
$stmt = $pdo->query("SELECT id, name FROM terms ORDER BY start_date DESC");
$all_terms = $stmt->fetchAll();

// Get course for edit
$edit_course = null;
if (isset($_GET['edit'])) {
    $course_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT c.*, ct.term_id, cc.class_id FROM courses c LEFT JOIN course_terms ct ON c.id = ct.course_id LEFT JOIN class_courses cc ON c.id = cc.course_id WHERE c.id = ?");
    $stmt->execute([$course_id]);
    $edit_course = $stmt->fetch();
}

include '../includes/admin_header.php';
?>

<style>
.fees-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.fees-table table {
    width: 100%;
    border-collapse: collapse;
}

.fees-table th,
.fees-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.fees-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.fees-table tr:hover {
    background: #f8f9fa;
}
</style>


<?php if ($message): ?>
    <div class="message"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if (!$edit_course): ?>
    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addCourseModal">Add New Course</button>
<?php endif; ?>

<?php if ($edit_course): ?>
    <h3>Edit Course</h3>

    <form method="post" action="manage_courses.php">
        <input type="hidden" name="course_id" value="<?php echo $edit_course['id']; ?>">

        <div class="form-group">
            <label for="code">Course/Subject Code:</label>
            <input type="text" id="code" name="code" value="<?php echo htmlspecialchars($edit_course['code'] ?? ''); ?>" required>
        </div>

        <div class="form-group">
            <label for="name">Subject/Course Name:</label>
            <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($edit_course['name'] ?? ''); ?>" required>
        </div>

        

        <div class="form-group">
            <label>Terms:</label>
            <div style="max-height: 200px; overflow-y: auto; border: 1px solid #ccc; padding: 10px;">
                <?php
                // Fetch all term_ids assigned to this course for edit mode
                $assigned_term_ids = [];
                if ($edit_course) {
                    $stmt = $pdo->prepare("SELECT term_id FROM course_terms WHERE course_id = ?");
                    $stmt->execute([$edit_course['id']]);
                    $assigned_term_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
                }
                ?>
                <?php foreach ($all_terms as $term): ?>
                    <label style="display: block; margin-bottom: 5px;">
                        <input type="checkbox" name="terms[]" value="<?php echo $term['id']; ?>" <?php echo in_array($term['id'], $assigned_term_ids) ? 'checked' : ''; ?>>
                        <?php echo htmlspecialchars($term['name']); ?>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="form-group">
            <label>Classes:</label>
            <div style="max-height: 200px; overflow-y: auto; border: 1px solid #ccc; padding: 10px;">
                <?php
                // Fetch all class_ids assigned to this course for edit mode
                $assigned_class_ids = [];
                if ($edit_course) {
                    $stmt = $pdo->prepare("SELECT class_id FROM class_courses WHERE course_id = ?");
                    $stmt->execute([$edit_course['id']]);
                    $assigned_class_ids = $stmt->fetchAll(PDO::FETCH_COLUMN);
                }
                ?>
                <?php foreach ($classes as $class): ?>
                    <label style="display: block; margin-bottom: 5px;">
                        <input type="checkbox" name="classes[]" value="<?php echo $class['id']; ?>" <?php echo in_array($class['id'], $assigned_class_ids) ? 'checked' : ''; ?>>
                        <?php echo htmlspecialchars($class['name']); ?>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="form-group">
            <label for="description">Description:</label>
            <textarea id="description" name="description"><?php echo htmlspecialchars($edit_course['description'] ?? ''); ?></textarea>
        </div>

        <button type="submit" name="edit_course" class="btn btn-primary">Update Course</button>
        <a href="manage_courses.php" class="btn">Cancel</a>
    </form>
<?php endif; ?>

<!-- Modal for Add Course -->
<div class="modal fade" id="addCourseModal" tabindex="-1" role="dialog" aria-labelledby="addCourseModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <h5 class="modal-title" id="addCourseModalLabel">
                    <i class="fas fa-plus-circle"></i> Add New Course
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="manage_courses.php" id="addCourseForm">
                <div class="modal-body" style="padding: 30px;">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="modal_code" style="font-weight: 600; color: #495057;">
                                    <i class="fas fa-hashtag"></i> Course/Subject Code:
                                </label>
                                <input type="text" id="modal_code" name="code" class="form-control" required
                                       style="border-radius: 8px; border: 2px solid #e9ecef; padding: 12px;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="modal_name" style="font-weight: 600; color: #495057;">
                                    <i class="fas fa-book"></i> Subject/Course Name:
                                </label>
                                <input type="text" id="modal_name" name="name" class="form-control" required
                                       style="border-radius: 8px; border: 2px solid #e9ecef; padding: 12px;">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="modal_description" style="font-weight: 600; color: #495057;">
                            <i class="fas fa-align-left"></i> Description:
                        </label>
                        <textarea id="modal_description" name="description" class="form-control" rows="3"
                                  style="border-radius: 8px; border: 2px solid #e9ecef; padding: 12px;"></textarea>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="font-weight: 600; color: #495057; display: block;">
                                    <i class="fas fa-calendar-alt"></i> Terms:
                                </label>
                                <div class="checkbox-container" style="max-height: 200px; overflow-y: auto; border: 2px solid #e9ecef; border-radius: 8px; padding: 15px; background: #f8f9fa;">
                                    <div class="select-all-container" style="margin-bottom: 10px; padding-bottom: 10px; border-bottom: 1px solid #dee2e6;">
                                        <label style="font-weight: 600; color: #495057; cursor: pointer;">
                                            <input type="checkbox" id="selectAllTerms" style="margin-right: 8px;">
                                            <i class="fas fa-check-square"></i> Select All Terms
                                        </label>
                                    </div>
                                    <?php foreach ($all_terms as $term): ?>
                                        <label style="display: block; margin-bottom: 8px; cursor: pointer; padding: 5px; border-radius: 4px; transition: background 0.2s;">
                                            <input type="checkbox" name="terms[]" value="<?php echo $term['id']; ?>" class="term-checkbox" style="margin-right: 8px;">
                                            <i class="fas fa-calendar-check" style="color: #28a745;"></i> <?php echo htmlspecialchars($term['name']); ?>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label style="font-weight: 600; color: #495057; display: block;">
                                    <i class="fas fa-users"></i> Classes:
                                </label>
                                <div class="checkbox-container" style="max-height: 200px; overflow-y: auto; border: 2px solid #e9ecef; border-radius: 8px; padding: 15px; background: #f8f9fa;">
                                    <div class="select-all-container" style="margin-bottom: 10px; padding-bottom: 10px; border-bottom: 1px solid #dee2e6;">
                                        <label style="font-weight: 600; color: #495057; cursor: pointer;">
                                            <input type="checkbox" id="selectAllClasses" style="margin-right: 8px;">
                                            <i class="fas fa-check-square"></i> Select All Classes
                                        </label>
                                    </div>
                                    <?php foreach ($classes as $class): ?>
                                        <label style="display: block; margin-bottom: 8px; cursor: pointer; padding: 5px; border-radius: 4px; transition: background 0.2s;">
                                            <input type="checkbox" name="classes[]" value="<?php echo $class['id']; ?>" class="class-checkbox" style="margin-right: 8px;">
                                            <i class="fas fa-graduation-cap" style="color: #007bff;"></i> <?php echo htmlspecialchars($class['name']); ?>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" style="background: #f8f9fa; border-top: 2px solid #e9ecef;">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal" style="border-radius: 8px; padding: 10px 20px;">
                        <i class="fas fa-times"></i> Cancel
                    </button>
                    <button type="submit" name="add_course" class="btn btn-primary" style="border-radius: 8px; padding: 10px 20px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none;">
                        <i class="fas fa-plus"></i> Add Course
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Select All functionality for Terms
document.getElementById('selectAllTerms').addEventListener('change', function() {
    const termCheckboxes = document.querySelectorAll('.term-checkbox');
    termCheckboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// Select All functionality for Classes
document.getElementById('selectAllClasses').addEventListener('change', function() {
    const classCheckboxes = document.querySelectorAll('.class-checkbox');
    classCheckboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
});

// Update Select All checkbox when individual checkboxes change
document.addEventListener('change', function(e) {
    if (e.target.classList.contains('term-checkbox')) {
        const allTerms = document.querySelectorAll('.term-checkbox');
        const checkedTerms = document.querySelectorAll('.term-checkbox:checked');
        document.getElementById('selectAllTerms').checked = allTerms.length === checkedTerms.length;
    }

    if (e.target.classList.contains('class-checkbox')) {
        const allClasses = document.querySelectorAll('.class-checkbox');
        const checkedClasses = document.querySelectorAll('.class-checkbox:checked');
        document.getElementById('selectAllClasses').checked = allClasses.length === checkedClasses.length;
    }
});

// Form validation
document.getElementById('addCourseForm').addEventListener('submit', function(e) {
    const code = document.getElementById('modal_code').value.trim();
    const name = document.getElementById('modal_name').value.trim();
    const termsChecked = document.querySelectorAll('.term-checkbox:checked').length;
    const classesChecked = document.querySelectorAll('.class-checkbox:checked').length;

    if (!code || !name) {
        e.preventDefault();
        alert('Please fill in all required fields.');
        return;
    }

    if (termsChecked === 0) {
        e.preventDefault();
        alert('Please select at least one term.');
        return;
    }

    if (classesChecked === 0) {
        e.preventDefault();
        alert('Please select at least one class.');
        return;
    }
});
</script>

<h3>All Courses</h3>

<table class="fees-table">
    <thead>
        <tr>
            <th>ID</th>
            <th>Code</th>
            <th>Name</th>
            <th>Class</th>
            <th>Term</th>
            <th>Description</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($courses as $course): ?>
            <tr>
                <td><?php echo $course['id']; ?></td>
                <td><?php echo htmlspecialchars($course['code'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($course['name']); ?></td>
                <td><?php echo htmlspecialchars($course['class_names'] ?? 'Not Assigned'); ?></td>
                <td><?php echo htmlspecialchars($course['term_names'] ?? 'Not Assigned'); ?></td>
                <td><?php echo htmlspecialchars($course['description']); ?></td>
                <td>
                    <a href="?edit=<?php echo $course['id']; ?>" class="btn btn-small">Edit</a>
                    <form method="post" action="manage_courses.php" style="display:inline;">
                        <input type="hidden" name="course_id" value="<?php echo $course['id']; ?>">
                        <button type="submit" name="delete_course" class="btn btn-small btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
include '../includes/admin_footer.php';
?>
