<?php
require_once '../config.php';

try {
    // Create staff table
    $sql = "CREATE TABLE IF NOT EXISTS staff (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        username VARCHAR(100) NOT NULL,
        password VARCHAR(255) NOT NULL,
        role VARCHAR(50) NOT NULL,
        first_name VARCHAR(100),
        middle_name VARCHAR(100),
        last_name VARCHAR(100),
        dob DATE,
        gender VARCHAR(20),
        address TEXT,
        email VARCHAR(100),
        phone VARCHAR(20),
        ghana_card_number VARCHAR(20),
        qualification VARCHAR(255),
        job_position VARCHAR(100),
        staff_rank VARCHAR(100),
        hire_date DATE,
        profile_image VARCHAR(255),
        staff_id VARCHAR(50),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES staff_accounts(id) ON DELETE CASCADE
    )";

    $pdo->exec($sql);
    echo "Staff table created successfully.\n";

    // Add first_name and last_name to staff_accounts for better recognition
    try {
        $pdo->exec("ALTER TABLE staff_accounts ADD COLUMN first_name VARCHAR(100)");
        echo "Added first_name column to staff_accounts.\n";
    } catch (Exception $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') === false) {
            throw $e;
        }
        echo "first_name column already exists in staff_accounts.\n";
    }

    try {
        $pdo->exec("ALTER TABLE staff_accounts ADD COLUMN last_name VARCHAR(100)");
        echo "Added last_name column to staff_accounts.\n";
    } catch (Exception $e) {
        if (strpos($e->getMessage(), 'Duplicate column name') === false) {
            throw $e;
        }
        echo "last_name column already exists in staff_accounts.\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
