<?php
try {
    $pdo = new PDO('mysql:host=localhost;dbname=school_management', 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "Checking existing indexes in admins table:\n";

    $result = $pdo->query('SHOW INDEXES FROM admins');
    $indexes = $result->fetchAll(PDO::FETCH_ASSOC);

    foreach ($indexes as $index) {
        echo '- ' . $index['Key_name'] . ' (' . $index['Column_name'] . ')' . PHP_EOL;
    }

    echo "\nDropping existing tables...\n";
    $pdo->exec('DROP TABLE IF EXISTS admins, admin_logs, admin_sessions');

    echo "Tables dropped successfully!\n";

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage() . PHP_EOL;
}
?>
