<?php
require_once '../config.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['assign_fee'])) {
        $fee_id = $_POST['fee_id'];
        $student_ids = $_POST['student_ids'] ?? [];
        $due_date = $_POST['due_date'];

        try {
            $assigned_count = 0;
            foreach ($student_ids as $student_id) {
                // Get fee details
                $stmt = $pdo->prepare("SELECT * FROM fees WHERE id = ?");
                $stmt->execute([$fee_id]);
                $fee = $stmt->fetch();

                if ($fee) {
                    // Check if already assigned
                    $stmt = $pdo->prepare("SELECT id FROM student_fees WHERE student_id = ? AND fee_id = ?");
                    $stmt->execute([$student_id, $fee_id]);
                    $existing = $stmt->fetch();

                    if (!$existing) {
                        $stmt = $pdo->prepare("INSERT INTO student_fees (student_id, fee_id, amount, due_date) VALUES (?, ?, ?, ?)");
                        $stmt->execute([$student_id, $fee_id, $fee['amount'], $due_date]);
                        $assigned_count++;
                    }
                }
            }
            $message = "Fee assigned to $assigned_count student(s) successfully.";
        } catch (PDOException $e) {
            $message = 'Error assigning fee: ' . $e->getMessage();
        }
    }
}

// Get all fees
$stmt = $pdo->query("SELECT f.*, ay.year as academic_year FROM fees f LEFT JOIN academic_years ay ON f.academic_year_id = ay.id ORDER BY f.created_at DESC");
$fees = $stmt->fetchAll();

// Get filter values
$filter_class = $_GET['class'] ?? '';
$filter_academic_year = $_GET['academic_year'] ?? '';

// Get students with optional filters
$query = "SELECT s.*, CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) as name, u.username FROM students s JOIN users u ON s.user_id = u.id WHERE 1=1";
$params = [];

if ($filter_class) {
    $query .= " AND s.class = ?";
    $params[] = $filter_class;
}
if ($filter_academic_year) {
    $query .= " AND s.academic_year = ?";
    $params[] = $filter_academic_year;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$students = $stmt->fetchAll();

// Get distinct classes and academic years for filter dropdowns
$classes_stmt = $pdo->query("SELECT name FROM classes ORDER BY name");
$classes = $classes_stmt->fetchAll(PDO::FETCH_COLUMN);

$years_stmt = $pdo->query("SELECT year FROM academic_years ORDER BY year DESC");
$academic_years = $years_stmt->fetchAll(PDO::FETCH_COLUMN);

include '../includes/admin_header.php';
?>

<h2>Assign Fees to Students</h2>

<?php if ($message): ?>
    <div class="message"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<form method="get" action="assign_fees.php" class="filter-form">
    <label for="class">Filter Students by Class:</label>
    <select id="class" name="class">
        <option value="">All</option>
        <?php foreach ($classes as $class): ?>
            <option value="<?php echo htmlspecialchars($class); ?>" <?php if ($class == $filter_class) echo 'selected'; ?>>
                <?php echo htmlspecialchars($class); ?>
            </option>
        <?php endforeach; ?>
    </select>

    <label for="academic_year">Filter by Academic Year:</label>
    <select id="academic_year" name="academic_year">
        <option value="">All</option>
        <?php foreach ($academic_years as $year): ?>
            <option value="<?php echo htmlspecialchars($year); ?>" <?php if ($year == $filter_academic_year) echo 'selected'; ?>>
                <?php echo htmlspecialchars($year); ?>
            </option>
        <?php endforeach; ?>
    </select>

    <button type="submit" class="btn btn-secondary">Filter</button>
    <a href="assign_fees.php" class="btn">Clear Filters</a>
</form>

<form method="post" action="assign_fees.php">
    <div class="form-group">
        <label for="fee_id">Select Fee to Assign:</label>
        <select id="fee_id" name="fee_id" required>
            <option value="">Select Fee</option>
            <?php foreach ($fees as $fee): ?>
                <option value="<?php echo $fee['id']; ?>">
                    <?php echo htmlspecialchars($fee['name']); ?> - GHC <?php echo number_format($fee['amount'], 2); ?>
                    <?php if ($fee['class']): ?> (<?php echo htmlspecialchars($fee['class']); ?>)<?php endif; ?>
                    <?php if ($fee['academic_year']): ?> - <?php echo htmlspecialchars($fee['academic_year']); ?><?php endif; ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="form-group">
        <label for="due_date">Due Date:</label>
        <input type="date" id="due_date" name="due_date" required>
    </div>

    <h3>Select Students to Assign Fee:</h3>
    <div class="students-list">
        <div class="select-all">
            <label>
                <input type="checkbox" id="select_all"> Select All Students
            </label>
        </div>
        <?php foreach ($students as $student): ?>
            <div class="student-item">
                <label>
                    <input type="checkbox" name="student_ids[]" value="<?php echo $student['id']; ?>">
                    <?php echo htmlspecialchars($student['name']); ?> (<?php echo htmlspecialchars($student['class']); ?> - <?php echo htmlspecialchars($student['academic_year']); ?>)
                </label>
            </div>
        <?php endforeach; ?>
    </div>

    <button type="submit" name="assign_fee" class="btn btn-primary">Assign Fee</button>
</form>

<script>
document.getElementById('select_all').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('input[name="student_ids[]"]');
    checkboxes.forEach(cb => cb.checked = this.checked);
});
</script>

<style>
.students-list {
    max-height: 400px;
    overflow-y: auto;
    border: 1px solid #ddd;
    padding: 10px;
    margin: 10px 0;
}

.student-item {
    margin: 5px 0;
}

.select-all {
    margin-bottom: 10px;
    font-weight: bold;
}
</style>

<?php
include '../includes/admin_footer.php';
?>
