<?php
require_once 'config.php';

try {
    // Check if student 'favour' already exists
    $stmt = $pdo->prepare("SELECT id FROM students WHERE name = ? AND class = ?");
    $stmt->execute(['favour', 'JHS 1 Alpha']);
    $existing = $stmt->fetch();

    if ($existing) {
        echo "Student 'favour' already exists in JHS 1 Alpha with ID: {$existing['id']}\n";
        exit;
    }

    // Create a user for the student
    $username = 'favour123';
    $password = password_hash('password123', PASSWORD_DEFAULT);

    $stmt = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, 'student')");
    $stmt->execute([$username, $password]);
    $user_id = $pdo->lastInsertId();

    // Add student record
    $stmt = $pdo->prepare("INSERT INTO students (user_id, name, class, academic_year, dob, address, phone, parent_name, parent_phone, parent_email) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $user_id,
        'favour',
        'JHS 1 Alpha',
        '2024-2025',
        '2006-05-15', // Sample DOB
        '123 Sample St, Accra',
        '0241234567',
        'Parent Name',
        '0241234568',
        'parent@email.com'
    ]);

    echo "Student 'favour' added successfully to JHS 1 Alpha!\n";
    echo "Username: favour123\n";
    echo "Password: password123\n";

} catch (Exception $e) {
    echo "Error adding student: " . $e->getMessage() . "\n";
}
?>
