<?php
require_once '../config.php';

try {
    // First create the table if it doesn't exist
    $createSql = "
    CREATE TABLE IF NOT EXISTS chart_of_accounts (
        id INT AUTO_INCREMENT PRIMARY KEY,
        account_code VARCHAR(20) NOT NULL UNIQUE,
        account_name VARCHAR(100) NOT NULL,
        account_type ENUM('Asset', 'Liability', 'Equity', 'Revenue', 'Expense') NOT NULL,
        account_category VARCHAR(100) NULL,
        normal_balance ENUM('debit', 'credit') NOT NULL,
        is_control_account BOOLEAN DEFAULT FALSE,
        allow_manual_posting BOOLEAN DEFAULT TRUE,
        show_in_reports BOOLEAN DEFAULT TRUE,
        status ENUM('active', 'inactive') DEFAULT 'active',
        currency VARCHAR(10) DEFAULT 'GHS',
        department VARCHAR(100) NULL,
        budget_category VARCHAR(100) NULL,
        linked_cash_account_id INT NULL,
        parent_account_id INT NULL,
        description TEXT,
        is_active BOOLEAN DEFAULT TRUE,
        is_system_account BOOLEAN DEFAULT FALSE,
        current_balance DECIMAL(15,2) DEFAULT 0.00,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        created_by INT,
        FOREIGN KEY (parent_account_id) REFERENCES chart_of_accounts(id) ON DELETE SET NULL,
        FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE SET NULL,
        FOREIGN KEY (linked_cash_account_id) REFERENCES chart_of_accounts(id) ON DELETE SET NULL,
        INDEX idx_account_type (account_type),
        INDEX idx_account_code (account_code),
        INDEX idx_parent_account (parent_account_id),
        INDEX idx_is_system (is_system_account),
        INDEX idx_account_category (account_category),
        INDEX idx_department (department),
        INDEX idx_budget_category (budget_category)
    );
    ";
    $pdo->exec($createSql);
    echo "Table created successfully.\n";

    // Insert default data if table is empty
    $stmt = $pdo->query("SELECT COUNT(*) FROM chart_of_accounts");
    $count = $stmt->fetchColumn();
    if ($count == 0) {
        $insertSql = "
        INSERT INTO chart_of_accounts (account_code, account_name, account_type, account_category, normal_balance, description, is_system_account, is_control_account, allow_manual_posting, show_in_reports, status) VALUES
        ('1000', 'Cash', 'Asset', 'Current Asset', 'debit', 'Cash on hand and petty cash', TRUE, FALSE, TRUE, TRUE, 'active'),
        ('1001', 'Petty Cash', 'Asset', 'Current Asset', 'debit', 'Petty cash for small expenses', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('1100', 'Bank Accounts', 'Asset', 'Current Asset', 'debit', 'Bank checking and savings accounts', FALSE, TRUE, FALSE, TRUE, 'active'),
        ('1101', 'Main School Bank Account', 'Asset', 'Current Asset', 'debit', 'Primary school bank account', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('1102', 'Mobile Money Account', 'Asset', 'Current Asset', 'debit', 'Mobile money wallet for transactions', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('1200', 'Accounts Receivable', 'Asset', 'Current Asset', 'debit', 'Money owed to the school by students/others', FALSE, TRUE, FALSE, TRUE, 'active'),
        ('1300', 'Inventory', 'Asset', 'Current Asset', 'debit', 'School store inventory and supplies', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('1400', 'Equipment', 'Asset', 'Fixed Asset', 'debit', 'Computers, furniture, and teaching equipment', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('1500', 'Buildings', 'Asset', 'Fixed Asset', 'debit', 'School buildings and facilities', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('1600', 'Land', 'Asset', 'Fixed Asset', 'debit', 'School land and property', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('2000', 'Accounts Payable', 'Liability', 'Current Liability', 'credit', 'Money owed by the school to suppliers/vendors', FALSE, TRUE, FALSE, TRUE, 'active'),
        ('2100', 'Tuition Advances', 'Liability', 'Current Liability', 'credit', 'Advance payments received for tuition', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('2200', 'Accrued Expenses', 'Liability', 'Current Liability', 'credit', 'Expenses incurred but not yet paid', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('2300', 'Loans Payable', 'Liability', 'Long-term Liability', 'credit', 'Outstanding loans and borrowings', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('3000', 'General Fund', 'Equity', 'Equity', 'credit', 'General operating fund balance', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('3100', 'Scholarship Fund', 'Equity', 'Equity', 'credit', 'Fund for student scholarships', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('3200', 'PTA Fund', 'Equity', 'Equity', 'credit', 'Parent-Teacher Association fund', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('3300', 'Capital Fund', 'Equity', 'Equity', 'credit', 'Capital contributions and reserves', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('3400', 'Retained Earnings', 'Equity', 'Equity', 'credit', 'Accumulated profits and losses', TRUE, FALSE, FALSE, TRUE, 'active'),
        ('4000', 'Tuition Fees', 'Revenue', 'Operating Revenue', 'credit', 'Regular tuition and enrollment fees', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('4100', 'Grants', 'Revenue', 'Other Revenue', 'credit', 'Government and private grants', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('4200', 'Donations', 'Revenue', 'Other Revenue', 'credit', 'Donations from individuals and organizations', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('4300', 'Interest Income', 'Revenue', 'Other Revenue', 'credit', 'Interest earned on bank accounts', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('4400', 'Other Income', 'Revenue', 'Other Revenue', 'credit', 'Miscellaneous income sources', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5000', 'Salaries', 'Expense', 'Operating Expense', 'debit', 'Staff salaries and wages', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5100', 'Supplies', 'Expense', 'Operating Expense', 'debit', 'Office and teaching supplies', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5200', 'Maintenance', 'Expense', 'Operating Expense', 'debit', 'Building and equipment maintenance', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5300', 'Utilities', 'Expense', 'Operating Expense', 'debit', 'Electricity, water, internet, and phone', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5400', 'Transport', 'Expense', 'Operating Expense', 'debit', 'Transportation and travel expenses', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5500', 'Insurance', 'Expense', 'Operating Expense', 'debit', 'Insurance premiums', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5600', 'Professional Fees', 'Expense', 'Operating Expense', 'debit', 'Legal, audit, and consulting fees', FALSE, FALSE, TRUE, TRUE, 'active'),
        ('5700', 'Depreciation', 'Expense', 'Operating Expense', 'debit', 'Depreciation of fixed assets', FALSE, FALSE, TRUE, TRUE, 'active');
        ";
        $pdo->exec($insertSql);
        echo "Default accounts inserted successfully.\n";
    }

    echo "Database setup completed successfully!";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
