<?php
require_once '../config.php';

try {
    // Drop the table if exists
    $pdo->exec("DROP TABLE IF EXISTS chart_of_accounts");

    // Read the SQL file
    $sql = file_get_contents('create_chart_of_accounts.sql');

    // Execute the SQL
    $pdo->exec($sql);

    echo "✅ Chart of accounts table recreated successfully!\n";

    // Check if accounts were inserted
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM chart_of_accounts");
    $result = $stmt->fetch();
    echo "📊 " . $result['count'] . " accounts created in chart of accounts.\n";

    // Check for '1121'
    $stmt = $pdo->prepare("SELECT id, account_name FROM chart_of_accounts WHERE account_code = '1121'");
    $stmt->execute();
    $account = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($account) {
        echo "✅ Account '1121' found: {$account['account_name']}\n";
    } else {
        echo "❌ Account '1121' not found!\n";
    }

} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
