<?php
require_once '../config.php';

echo "Starting migration for purchase_orders table columns...\n";

try {
    // Add po_date column
    $pdo->exec("ALTER TABLE purchase_orders ADD COLUMN po_date DATE NOT NULL");
    echo "✓ Added po_date column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "✗ Error adding po_date column: " . $e->getMessage() . "\n";
    } else {
        echo "✓ po_date column already exists\n";
    }
}

try {
    // Add paid_by column
    $pdo->exec("ALTER TABLE purchase_orders ADD COLUMN paid_by INT NULL");
    echo "✓ Added paid_by column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "✗ Error adding paid_by column: " . $e->getMessage() . "\n";
    } else {
        echo "✓ paid_by column already exists\n";
    }
}

try {
    // Add paid_at column
    $pdo->exec("ALTER TABLE purchase_orders ADD COLUMN paid_at TIMESTAMP NULL");
    echo "✓ Added paid_at column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "✗ Error adding paid_at column: " . $e->getMessage() . "\n";
    } else {
        echo "✓ paid_at column already exists\n";
    }
}

try {
    // Add payment_method column
    $pdo->exec("ALTER TABLE purchase_orders ADD COLUMN payment_method VARCHAR(100) NULL");
    echo "✓ Added payment_method column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "✗ Error adding payment_method column: " . $e->getMessage() . "\n";
    } else {
        echo "✓ payment_method column already exists\n";
    }
}

try {
    // Add payment_comments column
    $pdo->exec("ALTER TABLE purchase_orders ADD COLUMN payment_comments TEXT NULL");
    echo "✓ Added payment_comments column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "✗ Error adding payment_comments column: " . $e->getMessage() . "\n";
    } else {
        echo "✓ payment_comments column already exists\n";
    }
}

try {
    // Add status column
    $pdo->exec("ALTER TABLE purchase_orders ADD COLUMN status ENUM('pending', 'approved', 'paid', 'delivered', 'cancelled') DEFAULT 'pending' NOT NULL");
    echo "✓ Added status column\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') === false) {
        echo "✗ Error adding status column: " . $e->getMessage() . "\n";
    } else {
        echo "✓ status column already exists\n";
    }
}

try {
    // Add foreign key constraint
    $pdo->exec("ALTER TABLE purchase_orders ADD CONSTRAINT fk_purchase_orders_paid_by FOREIGN KEY (paid_by) REFERENCES users(id) ON DELETE SET NULL");
    echo "✓ Added foreign key constraint for paid_by\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate key name') === false && strpos($e->getMessage(), 'already exists') === false) {
        echo "✗ Error adding foreign key: " . $e->getMessage() . "\n";
    } else {
        echo "✓ Foreign key constraint already exists\n";
    }
}

echo "Migration completed!\n";
?>
