<?php
require_once '../config.php';

// Get the user's role before destroying session
$user_role = isset($_SESSION['role']) ? $_SESSION['role'] : null;

// Destroy session
session_destroy();

// Redirect based on user role with logout message
if ($user_role === 'admin' || $user_role === 'super_admin' || $user_role === 'head_teacher') {
    header('Location: ../admin/index.php?message=logged_out');
} elseif ($user_role === 'accountant') {
    header('Location: index.php?message=logged_out');
} else {
    header('Location: ../login.php?message=logged_out');
}
exit;
?>
