<?php
// SMS Notification Class using Twilio API
// Note: Requires Twilio SDK to be installed via Composer: composer require twilio/sdk

class SMSNotification {
    private $account_sid;
    private $auth_token;
    private $from_number;

    public function __construct() {
        // Load Twilio settings from environment
        $this->account_sid = getenv('TWILIO_ACCOUNT_SID') ?: '';
        $this->auth_token = getenv('TWILIO_AUTH_TOKEN') ?: '';
        $this->from_number = getenv('TWILIO_FROM_NUMBER') ?: '';
    }

    public function send($to, $message) {
        // Check if Twilio SDK is available
        if (!class_exists('Twilio\Rest\Client')) {
            // Fallback: log the SMS (for testing)
            error_log("SMS to {$to}: {$message}");
            return true; // Return true for testing
        }

        // Use Twilio SDK
        try {
            $client = new Twilio\Rest\Client($this->account_sid, $this->auth_token);

            $client->messages->create(
                $to,
                [
                    'from' => $this->from_number,
                    'body' => $message
                ]
            );

            return true;
        } catch (Exception $e) {
            error_log("SMS sending failed: " . $e->getMessage());
            return false;
        }
    }
}
?>
