<?php
/**
 * Security Headers Implementation
 * Adds essential HTTP security headers to prevent common attacks
 */

// Prevent clickjacking
header("X-Frame-Options: DENY");

// Prevent MIME type sniffing
header("X-Content-Type-Options: nosniff");

// Enable XSS protection
header("X-XSS-Protection: 1; mode=block");

// Referrer Policy
header("Referrer-Policy: strict-origin-when-cross-origin");

// Content Security Policy (basic)
header("Content-Security-Policy: default-src 'self'; connect-src 'self' https://stackpath.bootstrapcdn.com https://cdn.jsdelivr.net; script-src 'self' 'unsafe-inline' https://cdnjs.cloudflare.com https://stackpath.bootstrapcdn.com https://code.jquery.com https://cdn.jsdelivr.net; style-src 'self' 'unsafe-inline' https://cdnjs.cloudflare.com https://stackpath.bootstrapcdn.com https://fonts.googleapis.com; font-src 'self' https://fonts.gstatic.com https://cdnjs.cloudflare.com; img-src 'self' data: https:;");

// HSTS (HTTP Strict Transport Security) - Only enable if HTTPS is properly configured
// header("Strict-Transport-Security: max-age=31536000; includeSubDomains; preload");

// Feature Policy / Permissions Policy
header("Permissions-Policy: geolocation=(), microphone=(), camera=()");

// Remove server information
header_remove("X-Powered-By");
?>
