<?php
// Email Notification Class using PHPMailer
// Note: Requires PHPMailer to be installed via Composer: composer require phpmailer/phpmailer

class EmailNotification {
    private $smtp_host;
    private $smtp_port;
    private $smtp_username;
    private $smtp_password;
    private $from_email;
    private $from_name;

    public function __construct() {
        // Load SMTP settings from config or environment
        $this->smtp_host = getenv('SMTP_HOST') ?: 'smtp.gmail.com';
        $this->smtp_port = getenv('SMTP_PORT') ?: 587;
        $this->smtp_username = getenv('SMTP_USERNAME') ?: '';
        $this->smtp_password = getenv('SMTP_PASSWORD') ?: '';
        $this->from_email = getenv('FROM_EMAIL') ?: 'noreply@school.com';
        $this->from_name = getenv('FROM_NAME') ?: 'School Management System';
    }

    public function send($to, $subject, $message, $is_html = false) {
        // Check if PHPMailer is available
        if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
            // Fallback to PHP mail() function
            return $this->sendWithMail($to, $subject, $message, $is_html);
        }

        // Use PHPMailer
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);

        try {
            // Server settings
            $mail->isSMTP();
            $mail->Host = $this->smtp_host;
            $mail->SMTPAuth = true;
            $mail->Username = $this->smtp_username;
            $mail->Password = $this->smtp_password;
            $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = $this->smtp_port;

            // Recipients
            $mail->setFrom($this->from_email, $this->from_name);
            $mail->addAddress($to);

            // Content
            $mail->isHTML($is_html);
            $mail->Subject = $subject;
            $mail->Body = $message;

            if ($is_html) {
                $mail->AltBody = strip_tags($message);
            }

            $mail->send();
            return true;
        } catch (Exception $e) {
            error_log("Email sending failed: " . $mail->ErrorInfo);
            return false;
        }
    }

    private function sendWithMail($to, $subject, $message, $is_html) {
        $headers = "From: {$this->from_name} <{$this->from_email}>\r\n";
        if ($is_html) {
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        }

        return mail($to, $subject, $message, $headers);
    }
}
?>
