<?php
session_start();

// Check permissions
if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], ['admin', 'accounts'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

require_once '../../config.php';

header('Content-Type: application/json');

if (!isset($_GET['po_id'])) {
    echo json_encode(['success' => false, 'message' => 'Purchase order ID is required']);
    exit;
}

$po_id = intval($_GET['po_id']);

try {
    // Get PO details
    $stmt = $pdo->prepare("
        SELECT po.*, s.name AS supplier_name, s.contact_person, s.phone, s.email,
               u.username AS created_by_name
        FROM purchase_orders po
        JOIN suppliers s ON po.supplier_id = s.id
        LEFT JOIN users u ON po.created_by = u.id
        WHERE po.id = ? AND po.status = 'approved'
    ");
    $stmt->execute([$po_id]);
    $po = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$po) {
        echo json_encode(['success' => false, 'message' => 'Purchase order not found or not approved']);
        exit;
    }

    // Get PO items
    $stmt = $pdo->prepare("
        SELECT poi.*, bc.name AS category_name
        FROM purchase_order_items poi
        LEFT JOIN budget_categories bc ON poi.category = bc.id
        WHERE poi.purchase_order_id = ?
        ORDER BY poi.id
    ");
    $stmt->execute([$po_id]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'po' => $po,
        'items' => $items
    ]);

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
