<?php
require_once '../config.php';

try {
    // Add new columns one by one
    $columns = [
        "account_category VARCHAR(100) NULL AFTER account_type",
        "is_control_account BOOLEAN DEFAULT FALSE AFTER normal_balance",
        "allow_manual_posting BOOLEAN DEFAULT TRUE AFTER is_control_account",
        "show_in_reports BOOLEAN DEFAULT TRUE AFTER allow_manual_posting",
        "status ENUM('active', 'inactive') DEFAULT 'active' AFTER show_in_reports",
        "currency VARCHAR(10) DEFAULT 'GHS' AFTER status",
        "department VARCHAR(100) NULL AFTER currency",
        "budget_category VARCHAR(100) NULL AFTER department",
        "linked_cash_account_id INT NULL AFTER budget_category"
    ];

    foreach ($columns as $column) {
        try {
            $pdo->exec("ALTER TABLE chart_of_accounts ADD COLUMN $column");
            echo "Added column: $column\n";
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate column name') === false) {
                echo "Error adding column $column: " . $e->getMessage() . "\n";
            } else {
                echo "Column $column already exists.\n";
            }
        }
    }

    // Add indexes
    $indexes = [
        "idx_account_category (account_category)",
        "idx_department (department)",
        "idx_budget_category (budget_category)"
    ];

    foreach ($indexes as $index) {
        try {
            $pdo->exec("ALTER TABLE chart_of_accounts ADD INDEX $index");
            echo "Added index: $index\n";
        } catch (PDOException $e) {
            if (strpos($e->getMessage(), 'Duplicate key name') === false) {
                echo "Error adding index $index: " . $e->getMessage() . "\n";
            } else {
                echo "Index $index already exists.\n";
            }
        }
    }

    // Add foreign key
    try {
        $pdo->exec("ALTER TABLE chart_of_accounts ADD FOREIGN KEY (linked_cash_account_id) REFERENCES chart_of_accounts(id) ON DELETE SET NULL");
        echo "Added foreign key for linked_cash_account_id\n";
    } catch (PDOException $e) {
        if (strpos($e->getMessage(), 'Duplicate key name') === false && strpos($e->getMessage(), 'already exists') === false) {
            echo "Error adding foreign key: " . $e->getMessage() . "\n";
        } else {
            echo "Foreign key already exists.\n";
        }
    }

    // Update existing accounts with account_category
    $pdo->exec("UPDATE chart_of_accounts SET account_category = CASE
        WHEN account_type = 'Asset' AND account_code LIKE '1%' THEN 'Current Asset'
        WHEN account_type = 'Asset' AND account_code LIKE '14%' THEN 'Fixed Asset'
        WHEN account_type = 'Asset' AND account_code LIKE '15%' THEN 'Fixed Asset'
        WHEN account_type = 'Asset' AND account_code LIKE '16%' THEN 'Fixed Asset'
        WHEN account_type = 'Liability' AND account_code LIKE '2%' THEN 'Current Liability'
        WHEN account_type = 'Liability' AND account_code LIKE '23%' THEN 'Long-term Liability'
        WHEN account_type = 'Equity' THEN 'Equity'
        WHEN account_type = 'Revenue' AND account_code LIKE '4%' THEN 'Operating Revenue'
        WHEN account_type = 'Revenue' AND account_code LIKE '41%' THEN 'Other Revenue'
        WHEN account_type = 'Revenue' AND account_code LIKE '42%' THEN 'Other Revenue'
        WHEN account_type = 'Revenue' AND account_code LIKE '43%' THEN 'Other Revenue'
        WHEN account_type = 'Revenue' AND account_code LIKE '44%' THEN 'Other Revenue'
        WHEN account_type = 'Expense' THEN 'Operating Expense'
        ELSE 'Other'
    END WHERE account_category IS NULL");

    echo "Updated existing accounts with categories.\n";
    echo "All columns added successfully!";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
