<?php
require_once '../config.php';
require_once 'accounting_functions.php';

try {
    $pdo->beginTransaction();

    // Check existing accounts
    $existingAccounts = [
        'Salaries and Wages Expense' => getChartAccountId($pdo, 'Salaries and Wages Expense'),
        'Employer SSNIT Expense' => getChartAccountId($pdo, 'Employer SSNIT Expense'),
        'PAYE Expense' => getChartAccountId($pdo, 'PAYE Expense'),
        'SSNIT Payable' => getChartAccountId($pdo, 'SSNIT Payable'),
        'PAYE Payable' => getChartAccountId($pdo, 'PAYE Payable'),
        'Net Salaries Payable' => getChartAccountId($pdo, 'Net Salaries Payable'),
        'Tier 2 Pension Expense' => getChartAccountId($pdo, 'Tier 2 Pension Expense'),
        'Tier 2 Pension Payable' => getChartAccountId($pdo, 'Tier 2 Pension Payable'),
    ];

    // Accounts to add if missing
    $accountsToAdd = [
        ['5000', 'Salaries and Wages Expense', 'Expense', 'Operating Expense', 'debit', 'Staff salaries and wages expense'],
        ['5080', 'Employer SSNIT Expense', 'Expense', 'Operating Expense', 'debit', 'Employer contribution to SSNIT'],
        ['5090', 'PAYE Expense', 'Expense', 'Operating Expense', 'debit', 'PAYE tax expense'],
        ['5100', 'Tier 2 Pension Expense', 'Expense', 'Operating Expense', 'debit', 'Tier 2 Pension contribution expense'],
        ['2080', 'SSNIT Payable', 'Liability', 'Current Liability', 'credit', 'Employee SSNIT contributions payable'],
        ['2090', 'PAYE Payable', 'Liability', 'Current Liability', 'credit', 'PAYE tax payable to government'],
        ['2100', 'Net Salaries Payable', 'Liability', 'Current Liability', 'credit', 'Net salaries payable to employees'],
        ['2110', 'Tier 2 Pension Payable', 'Liability', 'Current Liability', 'credit', 'Tier 2 Pension contributions payable'],
    ];

    $addedCount = 0;

    foreach ($accountsToAdd as $account) {
        $accountName = $account[1];

        if (!$existingAccounts[$accountName]) {
            // Check if account code already exists
            $stmt = $pdo->prepare("SELECT id FROM chart_of_accounts WHERE account_code = ?");
            $stmt->execute([$account[0]]);
            $existingCode = $stmt->fetch();

            if ($existingCode) {
                echo "Account code {$account[0]} already exists, skipping {$accountName}\n";
                continue;
            }

            // Add the account
            $stmt = $pdo->prepare("
                INSERT INTO chart_of_accounts
                (account_code, account_name, account_type, account_category, normal_balance, description, is_active, show_in_balance_sheet, is_system_account)
                VALUES (?, ?, ?, ?, ?, ?, TRUE, TRUE, TRUE)
            ");
            $stmt->execute([
                $account[0], // account_code
                $account[1], // account_name
                $account[2], // account_type
                $account[3], // account_category
                $account[4], // normal_balance
                $account[5], // description
            ]);

            echo "Added account: {$account[1]} (Code: {$account[0]})\n";
            $addedCount++;
        } else {
            echo "Account already exists: {$accountName}\n";
        }
    }

    $pdo->commit();
    echo "\nSuccessfully added {$addedCount} payroll accounts to the chart of accounts.\n";

} catch (Exception $e) {
    $pdo->rollBack();
    echo 'Error: ' . $e->getMessage() . "\n";
}
?>
