<?php
require_once 'config.php';

try {
    // Sync cash_accounts balances to match chart_of_accounts
    $stmt = $pdo->query('SELECT ca.id, ca.account_code, coa.current_balance FROM cash_accounts ca JOIN chart_of_accounts coa ON ca.account_code = coa.account_code');
    $accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Syncing cash_accounts balances to match chart_of_accounts...\n";
    foreach ($accounts as $account) {
        $updateStmt = $pdo->prepare('UPDATE cash_accounts SET current_balance = ? WHERE id = ?');
        $updateStmt->execute([$account['current_balance'], $account['id']]);
        echo "Updated cash account ID {$account['id']} (code: {$account['account_code']}) to balance: " . number_format($account['current_balance'], 2) . "\n";
    }
    echo "Sync complete!\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
