<?php
require_once 'config.php';

echo "<h1>Simple Permission Test</h1>";

if (!isset($_SESSION['user_id'])) {
    echo "<p style='color: red;'>❌ User not logged in</p>";
    echo "<p><a href='login.php'>Login here</a></p>";
    exit;
}

echo "<h2>User Information:</h2>";
echo "<p><strong>User ID:</strong> " . $_SESSION['user_id'] . "</p>";
echo "<p><strong>Role:</strong> " . ($_SESSION['role'] ?? 'Not set') . "</p>";

// Test basic role access directly
require_once 'includes/enhanced_access_control_fixed.php';

echo "<h2>Basic Role Access Test:</h2>";
$test_permissions = ['manage_roles', 'manage_user_roles', 'dashboard_access'];
foreach ($test_permissions as $permission) {
    $result = hasBasicRoleAccess($permission);
    echo "<p><strong>$permission:</strong> " . ($result ? "<span style='color: green;'>✅ PASS</span>" : "<span style='color: red;'>❌ FAIL</span>") . "</p>";
}

// Test the menu items directly
echo "<h2>Menu Items Test:</h2>";
$menu_items = getAccessibleMenuItems();
echo "<p><strong>Total accessible menu items:</strong> " . count($menu_items) . "</p>";

// Check if roles_permissions menu exists
if (isset($menu_items['roles_permissions'])) {
    echo "<p style='color: green;'>✅ Roles & Permissions menu found</p>";
    echo "<h3>Roles & Permissions submenu:</h3>";
    foreach ($menu_items['roles_permissions']['submenu'] as $key => $item) {
        echo "<div style='margin: 5px 0; padding: 5px; background: #e8f5e8;'>";
        echo "<strong>" . $item['name'] . "</strong>";
        if (isset($item['url'])) {
            echo " → " . $item['url'];
        }
        echo "</div>";
    }
} else {
    echo "<p style='color: red;'>❌ Roles & Permissions menu NOT found</p>";
    echo "<h3>All available menu items:</h3>";
    foreach ($menu_items as $key => $item) {
        echo "<div style='margin: 5px 0; padding: 5px; background: #f5f5f5;'>";
        echo "<strong>" . $item['name'] . "</strong> (" . $key . ")";
        if (isset($item['submenu'])) {
            echo " - Has " . count($item['submenu']) . " submenu items";
        }
        echo "</div>";
    }
}

// Test database connection
echo "<h2>Database Connection Test:</h2>";
try {
    $stmt = $pdo->query("SELECT 1");
    echo "<p style='color: green;'>✅ Database connection successful</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Database connection failed: " . $e->getMessage() . "</p>";
}

// Test if roles table exists
echo "<h2>Database Tables Test:</h2>";
try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM roles");
    $roles_count = $stmt->fetchColumn();
    echo "<p><strong>Roles in database:</strong> $roles_count</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Roles table error: " . $e->getMessage() . "</p>";
}

try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM permissions");
    $permissions_count = $stmt->fetchColumn();
    echo "<p><strong>Permissions in database:</strong> $permissions_count</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Permissions table error: " . $e->getMessage() . "</p>";
}

try {
    $stmt = $pdo->query("SELECT COUNT(*) FROM role_permissions");
    $role_permissions_count = $stmt->fetchColumn();
    echo "<p><strong>Role-Permission assignments:</strong> $role_permissions_count</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Role-Permissions table error: " . $e->getMessage() . "</p>";
}
?>
