// Mobile menu toggle functionality
(function() {
    'use strict';

    function initMobileMenu() {
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const sidebar = document.querySelector('.student-sidebar');
        const main = document.querySelector('.student-main');

        if (mobileMenuToggle && sidebar) {
            mobileMenuToggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                sidebar.classList.toggle('open');

                // Prevent body scroll when sidebar is open
                if (sidebar.classList.contains('open')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            });

            // Close sidebar when clicking outside
            if (main) {
                main.addEventListener('click', function(e) {
                    if (sidebar.classList.contains('open') && !sidebar.contains(e.target)) {
                        sidebar.classList.remove('open');
                        document.body.style.overflow = '';
                    }
                });
            }

            // Close sidebar on escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && sidebar.classList.contains('open')) {
                    sidebar.classList.remove('open');
                    document.body.style.overflow = '';
                }
            });
        }
    }

    // Initialize immediately if DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initMobileMenu);
    } else {
        initMobileMenu();
    }

    // Fallback: Try to initialize after a short delay in case elements load late
    setTimeout(function() {
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const sidebar = document.querySelector('.student-sidebar');

        if (mobileMenuToggle && sidebar && !mobileMenuToggle.hasAttribute('data-listener-added')) {
            mobileMenuToggle.setAttribute('data-listener-added', 'true');
            mobileMenuToggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();

                sidebar.classList.toggle('open');

                // Prevent body scroll when sidebar is open
                if (sidebar.classList.contains('open')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            });
        }
    }, 1000);
})();
