<?php
/**
 * Session Management and Timeout Check
 * Handles session expiration and redirects users appropriately
 */

// Check if session has expired
function checkSessionTimeout() {
    $timeout = 1800; // 30 minutes in seconds

    if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout) {
        // Session has expired
        session_unset();
        session_destroy();

        // Redirect based on role or to general login
        if (isset($_SESSION['role'])) {
            $role = $_SESSION['role'];
            if ($role === 'accountant') {
                header('Location: accounts/index.php?error=session_expired');
            } else {
                header('Location: login.php?error=session_expired');
            }
        } else {
            header('Location: login.php?error=session_expired');
        }
        exit;
    }

    // Update last activity time
    $_SESSION['last_activity'] = time();
}

// Check if user is logged in and session is valid
function requireLogin($redirect_url = 'login.php') {
    if (!isset($_SESSION['user_id'])) {
        header('Location: ' . $redirect_url);
        exit;
    }

    // Check session timeout
    checkSessionTimeout();
}

// Check if user has specific role
function requireRole($role, $redirect_url = 'login.php') {
    requireLogin($redirect_url);

    if ($_SESSION['role'] !== $role) {
        header('Location: ' . $redirect_url);
        exit;
    }
}

// Initialize session check for accounting pages
function initAccountingSession() {
    requireLogin('accounts/index.php');
    requireRole('accountant', 'accounts/index.php');
}
?>
