<?php
if (!isset($_SESSION['user_id']) || ($_SESSION['role'] != 'admin' && $_SESSION['role'] != 'accountant' && $_SESSION['role'] != 'head_teacher' && $_SESSION['role'] != 'super_admin')) {
    header('Location: ../dashboard.php');
    exit;
}

// Include enhanced access control for proper menu permissions
require_once 'enhanced_access_control_fixed.php';

// Deny accounts users access to admin panel
denyAccountsAccess();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>School Management System - Admin</title>
        <link rel="stylesheet" href="../css/style.css">
        <link rel="stylesheet" href="../css/admin_custom.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    </head>
<body>
    <div class="admin-container">
        <?php
        // Use enhanced access control to get accessible menu items
        $accessible_menu_items = getAccessibleMenuItems();
        include 'admin_sidebar.php';
        ?>
        <div class="admin-main">
            <header class="admin-header">
                <div class="header-content">
                    <button class="mobile-menu-toggle" id="mobile-menu-toggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div class="header-info">
                        <h1><i class="fas fa-school"></i> School Management System</h1>
                    <div class="header-meta">
                        <?php
                        $role_display = '';
                        switch($_SESSION['role']) {
                            case 'admin':
                                $role_display = 'Admin Panel';
                                break;
                            case 'super_admin':
                                $role_display = 'Super Admin Panel';
                                break;
                            case 'accounts':
                                $role_display = 'Accounts Panel';
                                break;
                            case 'head_teacher':
                                $role_display = 'Head Teacher Panel';
                                break;
                            default:
                                $role_display = 'Admin Panel';
                        }
                        ?>
                        <span class="admin-badge"><i class="fas fa-user-shield"></i> <?php echo $role_display; ?></span>
                        <span class="current-date"><i class="fas fa-calendar"></i> <?php echo date('M d, Y'); ?></span>
                    </div>
                    </div>
                </div>
            </header>

            <main>
<style>
    .admin-container {
        display: flex;
        min-height: 100vh;
        background-color: #f8f9fa;
    }

    .admin-main {
        margin-left: 280px;
        flex: 1;
        padding: 20px 20px 20px 0px;
    }

    .admin-header {
         background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
        padding: 15px 20px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        margin-bottom: 20px;
        margin-top: -20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .header-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .mobile-menu-toggle {
        display: none;
        background: none;
        border: none;
        font-size: 1.5em;
        color: #fff;
        cursor: pointer;
        padding: 10px;
        border-radius: 5px;
        transition: background-color 0.3s ease;
    }

    .mobile-menu-toggle:hover {
        background-color: rgba(255,255,255,0.1);
    }

    .header-info h1 {
        margin: 0 0 5px 0;
        color: #fff;
        font-size: 1.8em;
        font-weight: 600;
    }

    .header-info h1 i {
        color: #fff;
        margin-right: 10px;
    }

    .header-meta {
        display: flex;
        gap: 20px;
        align-items: center;
    }

    .admin-badge {
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: white;
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.85em;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .current-date {
        color: #fff;
        font-size: 0.9em;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .admin-main main {
        background: white;
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-bottom: 20px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .admin-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
        }

        .admin-sidebar.open {
            transform: translateX(0);
        }

        .admin-main {
            margin-left: 0;
        }

        .mobile-menu-toggle {
            display: block;
        }

        .header-content {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .header-meta {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }
    }
</style>
