<?php
require_once 'config.php';

try {
    // Check if teacher_courses table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'teacher_courses'");
    $table_exists = $stmt->fetch();

    if (!$table_exists) {
        echo "teacher_courses table does not exist.\n";
        exit;
    }

    // Count records in teacher_courses
    $stmt = $pdo->query("SELECT COUNT(*) FROM teacher_courses");
    $count = $stmt->fetchColumn();
    echo "Teacher courses count: $count\n";

    // Show some sample records
    $stmt = $pdo->query("SELECT tc.id, tc.teacher_id, tc.course_id, c.name as course_name, s.first_name, s.last_name
                        FROM teacher_courses tc
                        JOIN courses c ON tc.course_id = c.id
                        JOIN staff s ON tc.teacher_id = s.id
                        LIMIT 10");
    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "\nSample records:\n";
    foreach ($records as $record) {
        echo "ID: {$record['id']}, Teacher: {$record['first_name']} {$record['last_name']}, Course: {$record['course_name']}\n";
    }

    // Check courses table teacher_id assignments
    $stmt = $pdo->query("SELECT COUNT(*) FROM courses WHERE teacher_id IS NOT NULL");
    $assigned_count = $stmt->fetchColumn();
    echo "\nCourses with teacher_id assigned: $assigned_count\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
