<?php
require_once 'config.php';

echo "<h1>Students Table Structure</h1>";

$stmt = $pdo->query('DESCRIBE students');
$columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<table border='1'><tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
foreach ($columns as $col) {
    echo "<tr>";
    echo "<td>{$col['Field']}</td>";
    echo "<td>{$col['Type']}</td>";
    echo "<td>{$col['Null']}</td>";
    echo "<td>{$col['Key']}</td>";
    echo "<td>{$col['Default']}</td>";
    echo "<td>{$col['Extra']}</td>";
    echo "</tr>";
}
echo "</table>";

echo "<h2>Analysis of Current vs Required Fields</h2>";
echo "<p>Based on the enroll_students.php form, the required fields are:</p>";
echo "<ul>";
echo "<li>user_id (required)</li>";
echo "<li>first_name (required)</li>";
echo "<li>middle_name (optional)</li>";
echo "<li>last_name (required)</li>";
echo "<li>dob (optional)</li>";
echo "<li>gender (optional)</li>";
echo "<li>place_of_birth_city (optional)</li>";
echo "<li>place_of_birth_country (optional)</li>";
echo "<li>nationality (optional)</li>";
echo "<li>home_street (optional)</li>";
echo "<li>home_city (optional)</li>";
echo "<li>home_state (optional)</li>";
echo "<li>home_postal (optional)</li>";
echo "<li>home_country (optional)</li>";
echo "<li>student_id (optional)</li>";
echo "<li>previous_school_name (optional)</li>";
echo "<li>previous_school_address (optional)</li>";
echo "<li>class (required)</li>";
echo "<li>academic_year (required)</li>";
echo "<li>term_admission (optional)</li>";
echo "<li>languages_home (optional)</li>";
echo "<li>religion (optional)</li>";
echo "<li>phone (optional)</li>";
echo "<li>photo_path (optional)</li>";
echo "</ul>";

echo "<p>Current table has: name, class, academic_year, address, phone, parent_name, parent_phone, parent_email, dob</p>";
echo "<p><strong>Fields to remove:</strong> name (split into first_name, middle_name, last_name), address (split into home_* fields), parent_name, parent_phone, parent_email</p>";
echo "<p><strong>Fields to add:</strong> first_name, middle_name, last_name, gender, place_of_birth_city, place_of_birth_country, nationality, home_street, home_city, home_state, home_postal, home_country, student_id, previous_school_name, previous_school_address, term_admission, languages_home, religion, photo_path</p>";
?>
