<?php
require_once 'config.php';

echo "<h1>All Students in Database</h1>";

$stmt = $pdo->query("SELECT s.id, CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) as full_name, s.class, s.user_id, su.username, 'student' as role FROM students s JOIN student_users su ON s.user_id = su.id ORDER BY s.id");
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<p>Total students: " . count($students) . "</p>";

if (!empty($students)) {
    echo "<table border='1'><tr><th>ID</th><th>Name</th><th>Class</th><th>User ID</th><th>Username</th><th>Role</th></tr>";
    foreach ($students as $student) {
        echo "<tr><td>{$student['id']}</td><td>{$student['full_name']}</td><td>{$student['class']}</td><td>{$student['user_id']}</td><td>{$student['username']}</td><td>{$student['role']}</td></tr>";
    }
    echo "</table>";
} else {
    echo "<p>No students found.</p>";
}
?>
