<?php
require_once '../config.php';
require_once '../includes/access_control.php';

// requireFeatureAccess('course_management');

include '../includes/admin_header.php';

$message = '';

// Fetch distinct subjects from subjects table
$stmt = $pdo->query("SELECT DISTINCT name FROM subjects WHERE name IS NOT NULL AND name != ''");
$subjects = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Fetch all courses with assigned class names from class_courses
$stmt = $pdo->query("
    SELECT c.*,
           GROUP_CONCAT(DISTINCT cl.name ORDER BY cl.name SEPARATOR ', ') as assigned_classes
    FROM courses c
    LEFT JOIN class_courses cc ON c.id = cc.course_id
    LEFT JOIN classes cl ON cc.class_id = cl.id
    GROUP BY c.id
");
$courses = $stmt->fetchAll();

?>

<h2>View Subjects/Courses</h2>

<?php if (count($courses) > 0): ?>
    <table class="subjects-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Code</th>
                <th>Course Name</th>
                <th>Class</th>
                <th>Description</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($courses as $course): ?>
                <tr>
                    <td><?php echo $course['id']; ?></td>
                    <td><?php echo htmlspecialchars($course['code'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($course['name']); ?></td>
                    <td><?php echo htmlspecialchars($course['assigned_classes'] ?? 'Not Assigned'); ?></td>
                    <td><?php echo htmlspecialchars($course['description']); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>No courses found.</p>
<?php endif; ?>

<style>
.subjects-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.subjects-table table {
    width: 100%;
    border-collapse: collapse;
}

.subjects-table th,
.subjects-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.subjects-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.subjects-table tr:hover {
    background: #f8f9fa;
}
</style>

<?php
include '../includes/admin_footer.php';
?>
