<?php
require_once '../config.php';
require_once '../includes/enhanced_access_control_fixed.php';

// Require permission to access this page
requirePermission('accountant_management', '../login.php');

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_accountant'])) {
        $username = trim($_POST['username']);
        $password = $_POST['password'];
        $confirm_password = $_POST['confirm_password'];
        $first_name = trim($_POST['first_name']);
        $last_name = trim($_POST['last_name']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);

        $errors = [];

        if (empty($username) || empty($password) || empty($confirm_password) || empty($first_name) || empty($last_name)) {
            $errors[] = "Username, password, first name, and last name are required.";
        }

        if ($password !== $confirm_password) {
            $errors[] = "Passwords do not match.";
        }

        // Check if username already exists
        $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetch()) {
            $errors[] = "Username already exists.";
        }

        if (empty($errors)) {
            // Insert into users table
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $pdo->beginTransaction();
            try {
                $stmt = $pdo->prepare("INSERT INTO users (username, password, role, created_at) VALUES (?, ?, 'admin', NOW())");
                $stmt->execute([$username, $hashed_password]);
                $user_id = $pdo->lastInsertId();

                // Insert into admins table
                $stmt = $pdo->prepare("INSERT INTO admins (user_id, admin_level, first_name, last_name, email, phone, is_active, created_at) VALUES (?, 'accounts', ?, ?, ?, ?, 1, NOW())");
                $stmt->execute([$user_id, $first_name, $last_name, $email, $phone]);

                $pdo->commit();
                $message = 'Accountant added successfully.';
            } catch (Exception $e) {
                $pdo->rollBack();
                $message = 'Error adding accountant: ' . $e->getMessage();
            }
        } else {
            $message = implode('<br>', $errors);
        }
    } elseif (isset($_POST['edit_accountant'])) {
        $admin_id = $_POST['admin_id'];
        $first_name = trim($_POST['first_name']);
        $last_name = trim($_POST['last_name']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $is_active = isset($_POST['is_active']) ? 1 : 0;

        $stmt = $pdo->prepare("UPDATE admins SET first_name = ?, last_name = ?, email = ?, phone = ?, is_active = ?, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$first_name, $last_name, $email, $phone, $is_active, $admin_id]);

        $message = 'Accountant updated successfully.';
    } elseif (isset($_POST['delete_accountant'])) {
        $admin_id = $_POST['admin_id'];

        // Get user_id first
        $stmt = $pdo->prepare("SELECT user_id FROM admins WHERE id = ?");
        $stmt->execute([$admin_id]);
        $admin = $stmt->fetch();

        if ($admin) {
            // Delete admin record (cascade will delete user)
            $stmt = $pdo->prepare("DELETE FROM admins WHERE id = ?");
            $stmt->execute([$admin_id]);

            $message = 'Accountant deleted successfully.';
        }
    }
}

// Get all accountants
$stmt = $pdo->query("
    SELECT a.*, u.username
    FROM admins a
    JOIN users u ON a.user_id = u.id
    WHERE a.admin_level = 'accounts'
    ORDER BY a.created_at DESC
");
$accountants = $stmt->fetchAll();

// Get accountant for edit
$edit_accountant = null;
if (isset($_GET['edit'])) {
    $admin_id = $_GET['edit'];
    $stmt = $pdo->prepare("
        SELECT a.*, u.username
        FROM admins a
        JOIN users u ON a.user_id = u.id
        WHERE a.id = ?
    ");
    $stmt->execute([$admin_id]);
    $edit_accountant = $stmt->fetch();
}

include '../includes/admin_header.php';
?>

<style>
.form-row {
    display: flex;
    gap: 20px;
    margin-bottom: 15px;
}
.form-row .form-group {
    flex: 1;
}
.form-row .form-group:last-child {
    margin-bottom: 0;
}
fieldset {
    margin-bottom: 20px;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 15px;
}
legend {
    font-weight: bold;
    color: #333;
}

.accountants-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.accountants-table table {
    width: 100%;
    border-collapse: collapse;
}

.accountants-table th,
.accountants-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.accountants-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.accountants-table tr:hover {
    background: #f8f9fa;
}

.status-active {
    color: #28a745;
    font-weight: bold;
}

.status-inactive {
    color: #dc3545;
    font-weight: bold;
}
</style>

<h2>Manage Accountants</h2>

<?php if ($message): ?>
    <div class="message"><?php echo $message; ?></div>
<?php endif; ?>

<!-- Button to trigger add modal -->
<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addAccountantModal">Add New Accountant</button>

<!-- Add Accountant Modal -->
<div class="modal fade" id="addAccountantModal" tabindex="-1" role="dialog" aria-labelledby="addAccountantModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addAccountantModalLabel">Add New Accountant</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" action="manage_accountants.php" id="addAccountantForm">
                    <fieldset>
                        <legend>Login Credentials</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="username">👤 Username:</label>
                                <input type="text" id="username" name="username" required>
                            </div>
                            <div class="form-group">
                                <label for="password">🔒 Password:</label>
                                <input type="password" id="password" name="password" required>
                            </div>
                            <div class="form-group">
                                <label for="confirm_password">🔒 Confirm Password:</label>
                                <input type="password" id="confirm_password" name="confirm_password" required>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Personal Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="first_name">👤 First Name:</label>
                                <input type="text" id="first_name" name="first_name" required>
                            </div>
                            <div class="form-group">
                                <label for="last_name">👤 Last Name:</label>
                                <input type="text" id="last_name" name="last_name" required>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="email">📧 Email:</label>
                                <input type="email" id="email" name="email">
                            </div>
                            <div class="form-group">
                                <label for="phone">📞 Phone:</label>
                                <input type="text" id="phone" name="phone">
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="submit" form="addAccountantForm" name="add_accountant" class="btn btn-primary">Add Accountant</button>
            </div>
        </div>
    </div>
</div>

<?php if ($edit_accountant): ?>
<h3>Edit Accountant</h3>

<form method="post" action="manage_accountants.php">
    <input type="hidden" name="admin_id" value="<?php echo $edit_accountant['id']; ?>">

    <fieldset>
        <legend>Login Credentials</legend>
        <div class="form-row">
            <div class="form-group">
                <label for="username">👤 Username:</label>
                <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($edit_accountant['username'] ?? ''); ?>" readonly>
                <small class="text-muted">Username cannot be changed</small>
            </div>
        </div>
    </fieldset>

    <fieldset>
        <legend>Personal Information</legend>
        <div class="form-row">
            <div class="form-group">
                <label for="first_name">👤 First Name:</label>
                <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($edit_accountant['first_name'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="last_name">👤 Last Name:</label>
                <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($edit_accountant['last_name'] ?? ''); ?>" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label for="email">📧 Email:</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($edit_accountant['email'] ?? ''); ?>">
            </div>
            <div class="form-group">
                <label for="phone">📞 Phone:</label>
                <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($edit_accountant['phone'] ?? ''); ?>">
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label for="is_active">
                    <input type="checkbox" id="is_active" name="is_active" <?php echo ($edit_accountant['is_active'] ?? 0) ? 'checked' : ''; ?>> Active Account
                </label>
            </div>
        </div>
    </fieldset>

    <button type="submit" name="edit_accountant" class="btn btn-primary">Update Accountant</button>
    <a href="manage_accountants.php" class="btn">Cancel</a>
</form>
<?php endif; ?>

<h3>All Accountants</h3>

<table class="accountants-table">
    <thead>
        <tr>
            <th>Username</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Status</th>
            <th>Created</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($accountants as $accountant): ?>
            <tr>
                <td><?php echo htmlspecialchars($accountant['username']); ?></td>
                <td><?php echo htmlspecialchars(trim(($accountant['first_name'] ?? '') . ' ' . ($accountant['last_name'] ?? ''))); ?></td>
                <td><?php echo htmlspecialchars($accountant['email'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($accountant['phone'] ?? ''); ?></td>
                <td>
                    <span class="status-<?php echo ($accountant['is_active'] ?? 0) ? 'active' : 'inactive'; ?>">
                        <?php echo ($accountant['is_active'] ?? 0) ? 'Active' : 'Inactive'; ?>
                    </span>
                </td>
                <td><?php echo htmlspecialchars($accountant['created_at'] ?? ''); ?></td>
                <td>
                    <a href="?edit=<?php echo $accountant['id']; ?>" class="btn btn-small" style="background-color: #28a745; color: white;">Edit</a>
                    <form method="post" action="manage_accountants.php" style="display:inline;">
                        <input type="hidden" name="admin_id" value="<?php echo $accountant['id']; ?>">
                        <button type="submit" name="delete_accountant" class="btn btn-small btn-danger" onclick="return confirm('Are you sure you want to delete this accountant?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
include '../includes/admin_footer.php';
?>
