<?php
session_start();
require_once '../config.php';
require_once '../includes/enhanced_access_control_fixed.php';

// Check if user has permission to manage roles
requirePermission('role_management');

if (!isset($_GET['role_id'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Role ID required']);
    exit;
}

$role_id = $_GET['role_id'];

try {
    // Get role details
    $stmt = $pdo->prepare("SELECT * FROM roles WHERE id = ?");
    $stmt->execute([$role_id]);
    $role = $stmt->fetch();

    if (!$role) {
        http_response_code(404);
        echo json_encode(['error' => 'Role not found']);
        exit;
    }

    // Get role permissions
    $stmt = $pdo->prepare("SELECT permission_id FROM role_permissions WHERE role_id = ?");
    $stmt->execute([$role_id]);
    $permissions = $stmt->fetchAll(PDO::FETCH_COLUMN);

    echo json_encode([
        'role' => $role,
        'permissions' => $permissions
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
