<!-- <?php
require_once '../config.php';
require_once '../includes/access_control.php';

// Set headers for Server-Sent Events
header('Content-Type: text/event-stream');
header('Cache-Control: no-cache');
header('Connection: keep-alive');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Cache-Control');

// Disable output buffering
if (ob_get_level()) {
    ob_end_clean();
}

// Get the group ID from the request
$group_id = $_GET['group_id'] ?? null;
$user_id = $_SESSION['user_id'] ?? null;

if (!$group_id || !$user_id) {
    echo "data: " . json_encode(['error' => 'Invalid group or user']) . "\n\n";
    exit;
}

// Check if user is participant in the group
$stmt = $pdo->prepare("SELECT id FROM discussion_participants WHERE discussion_group_id = ? AND user_id = ? AND is_active = TRUE");
$stmt->execute([$group_id, $user_id]);
if ($stmt->rowCount() == 0) {
    echo "data: " . json_encode(['error' => 'Access denied']) . "\n\n";
    exit;
}

// Get the last message ID to know where to start
$last_message_id = $_GET['last_message_id'] ?? 0;

// Function to send SSE data
function sendSSE($data) {
    echo "data: " . json_encode($data) . "\n\n";
    ob_flush();
    flush();
}

// Send initial connection confirmation
sendSSE(['type' => 'connected', 'group_id' => $group_id]);

// Keep connection alive and check for new messages
$last_check = time();
while (true) {
    try {
        // Check for new messages every 2 seconds
        if (time() - $last_check >= 2) {
            $stmt = $pdo->prepare("
                SELECT dm.*, CONCAT(t.first_name, ' ', t.last_name) as sender_name, t.profile_image
                FROM discussion_messages dm
                LEFT JOIN teachers t ON dm.user_id = t.user_id
                WHERE dm.discussion_group_id = ? AND dm.id > ? AND dm.is_deleted = FALSE
                ORDER BY dm.created_at ASC
            ");
            $stmt->execute([$group_id, $last_message_id]);
            $new_messages = $stmt->fetchAll();

            if (!empty($new_messages)) {
                foreach ($new_messages as $message) {
                    $last_message_id = $message['id'];
                    sendSSE([
                        'type' => 'new_message',
                        'message' => [
                            'id' => $message['id'],
                            'message' => $message['message'],
                            'sender_name' => $message['sender_name'],
                            'user_id' => $message['user_id'],
                            'created_at' => $message['created_at'],
                            'message_type' => $message['message_type']
                        ]
                    ]);
                }
            }

            $last_check = time();
        }

        // Check if client is still connected
        if (connection_aborted()) {
            break;
        }

        // Sleep for a short time to prevent excessive CPU usage
        sleep(1);

    } catch (Exception $e) {
        sendSSE(['type' => 'error', 'message' => 'Database error']);
        break;
    }
}
?> -->
