<?php
require_once '../config.php';

// Check if user is logged in and is admin
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT last_name FROM admins WHERE id = ?");
$stmt->execute([$user_id]);
$admin = $stmt->fetch();
$last_name = $admin ? $admin['last_name'] : $_SESSION['username'];

// Fetch statistics for admin dashboard
$total_students = $pdo->query("SELECT COUNT(*) FROM students")->fetchColumn();
$total_courses = $pdo->query("SELECT COUNT(*) FROM courses")->fetchColumn();
$total_enrollments = $pdo->query("SELECT COUNT(*) FROM enrollments")->fetchColumn();
$total_classes = $pdo->query("SELECT COUNT(*) FROM classes")->fetchColumn();

// Get recent activities
$recent_students = $pdo->query("SELECT CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) as name, u.username, s.created_at FROM students s JOIN users u ON s.user_id = u.id ORDER BY s.created_at DESC LIMIT 3")->fetchAll();

include '../includes/admin_header.php';
?>

<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>🏫 Welcome back, <?php echo htmlspecialchars($last_name); ?>!</h1>
        <p class="dashboard-subtitle">Administrator Dashboard - Manage your school system efficiently</p>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">👨‍🎓</div>
            <div class="stat-content">
                <h3><?php echo $total_students; ?></h3>
                <p>Total Students</p>
            </div>
        </div>



        <div class="stat-card">
            <div class="stat-icon">📚</div>
            <div class="stat-content">
                <h3><?php echo $total_courses; ?></h3>
                <p>Total Courses/Subjects</p>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon">🏫</div>
            <div class="stat-content">
                <h3><?php echo $total_classes; ?></h3>
                <p>Total Classes</p>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="quick-actions">
        <h2>Quick Actions</h2>
        <div class="actions-grid">
            <a href="manage_students.php" class="action-card">
                <div class="action-icon">➕</div>
                <div class="action-content">
                    <h4>Manage Students</h4>
                    <p>Add, edit, or remove students</p>
                </div>
            </a>

            <a href="manage_staff.php" class="action-card">
                <div class="action-icon">👨‍🏫</div>
                <div class="action-content">
                    <h4>Manage Staff</h4>
                    <p>Add or edit Staff</p>
                </div>
            </a>

            <a href="manage_courses.php" class="action-card">
                <div class="action-icon">📝</div>
                <div class="action-content">
                    <h4>Manage Courses</h4>
                    <p>Create and manage courses</p>
                </div>
            </a>

            <a href="view_classes.php" class="action-card">
                <div class="action-icon">🏫</div>
                <div class="action-content">
                    <h4>View Classes</h4>
                    <p>Manage class assignments</p>
                </div>
            </a>

            <a href="manage_facilities.php" class="action-card">
                <div class="action-icon">🏢</div>
                <div class="action-content">
                    <h4>Facility Management</h4>
                    <p>Manage facility bookings and resources</p>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Activity -->
    <div class="recent-activity">
        <div class="activity-section">
            <h3>Recently Added Students</h3>
            <?php if (empty($recent_students)): ?>
                <p>No recent student registrations.</p>
            <?php else: ?>
                <ul class="activity-list">
                    <?php foreach ($recent_students as $student): ?>
                        <li class="activity-item">
                            <div class="activity-icon">👨‍🎓</div>
                            <div class="activity-content">
                                <strong><?php echo htmlspecialchars($student['name']); ?></strong>
                                <small>Registered on <?php echo date('M j, Y', strtotime($student['created_at'])); ?></small>
                            </div>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>


    </div>
</div>

<?php
include '../includes/admin_footer.php';
?>
