<?php
// This file demonstrates integration of Select2 library for enhanced select dropdowns in student_sales.php

// Include necessary CSS and JS for Select2
?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2 on student select dropdown
    $('#student_id').select2({
        placeholder: "Select Student",
        width: '100%'
    });

    // Initialize Select2 on item select dropdowns
    $('.item-select').select2({
        placeholder: "Select Item",
        width: '100%'
    });

    // Re-initialize Select2 on dynamically added item selects
    window.addItem = function() {
        const container = document.getElementById('itemsContainer');
        const itemRow = document.createElement('div');
        itemRow.className = 'item-row border p-3 mb-3';
        itemRow.innerHTML = `
            <div class="row">
                <div class="col-md-4">
                    <label>Item</label>
                    <select class="form-control item-select" name="items[${itemIndex}][item_id]" required onchange="updatePrice(this)">
                        <option value="">Select Item</option>
                        <?php foreach ($items as $item): ?>
                            <option value="<?php echo $item['id']; ?>" data-price="<?php echo $item['selling_price']; ?>" data-stock="<?php echo $item['stock']; ?>">
                                <?php echo htmlspecialchars($item['name']); ?> (Stock: <?php echo $item['stock']; ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label>Quantity</label>
                    <input type="number" class="form-control quantity-input" name="items[${itemIndex}][quantity]" min="1" required onchange="calculateRowTotal(this)">
                </div>
                <div class="col-md-2">
                    <label>Unit Price</label>
                    <input type="number" step="0.01" class="form-control unit-price-input" name="items[${itemIndex}][unit_price]" min="0" required onchange="calculateRowTotal(this)">
                </div>
                <div class="col-md-2">
                    <label>Total</label>
                    <input type="text" class="form-control row-total" readonly>
                </div>
                <div class="col-md-2">
                    <label>&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-block" onclick="removeItem(this)">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </div>
        `;
        container.appendChild(itemRow);
        // Initialize Select2 on the new item select
        $(itemRow).find('.item-select').select2({
            placeholder: "Select Item",
            width: '100%'
        });
        itemIndex++;
        updateGrandTotal();
    }
});
</script>
<?php
// Note: This code snippet is to be integrated into accounts/student_sales.php replacing the addItem function and adding Select2 initialization.
// This will provide enhanced select dropdowns with search and better UI.
?>
