<?php
require_once '../config.php';

$error = '';

// Check for session expired message
if (isset($_GET['error']) && $_GET['error'] === 'session_expired') {
    $error = 'Your session has expired. Please log in again.';
}

// Check for logout message
if (isset($_GET['message']) && $_GET['message'] === 'logged_out') {
    $error = 'You have been successfully logged out. Please log in again to continue.';
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error = 'Please fill in all fields.';
    } else {
        // Check user credentials in staff_accounts table
        $stmt = $pdo->prepare("
            SELECT su.id, su.password, s.role, s.first_name, s.last_name
            FROM staff_accounts su
            LEFT JOIN staff s ON su.id = s.user_id
            WHERE su.username = ? AND s.role = 'accountant' AND su.status = 'active'
        ");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            // Set session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $user['role'];
            $_SESSION['first_name'] = $user['first_name'] ?? '';
            $_SESSION['last_name'] = $user['last_name'] ?? '';
            $_SESSION['last_activity'] = time(); // Initialize session activity

            // Redirect to accounting dashboard
            header('Location: accounting_dashboard.php');
            exit;
        } else {
            $error = 'Invalid username or password.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accounting Login - School Management System</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #2E7D32 0%, #4CAF50 100%);
            min-height: 100vh;
            margin: 0;
            position: relative;
            overflow-x: hidden;
        }

        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-image:
                radial-gradient(circle at 25% 25%, rgba(255,255,255,0.1) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(255,255,255,0.1) 0%, transparent 50%);
            background-size: 100px 100px;
            opacity: 0.3;
        }

        .top-bar {
            background-color: rgba(255,255,255,0.95);
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            padding: 15px 0;
            backdrop-filter: blur(10px);
        }

        .top-bar .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .top-bar .logo {
            font-size: 1.5em;
            font-weight: bold;
            color: #2E7D32;
            display: flex;
            align-items: center;
        }

        .top-bar .logo i {
            margin-right: 10px;
            font-size: 1.8em;
        }

        .top-bar .nav-links {
            display: flex;
            gap: 30px;
            align-items: center;
        }

        .top-bar .nav-links a {
            color: #666;
            text-decoration: none;
            font-weight: 500;
            display: flex;
            align-items: center;
            transition: color 0.3s ease;
        }

        .top-bar .nav-links a:hover {
            color: #2E7D32;
        }

        .top-bar .nav-links a i {
            margin-right: 8px;
        }

        .main-content {
            padding-top: 80px;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            z-index: 1;
        }

        .login-container {
            background-color: rgba(255,255,255,0.98);
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 500px;
            border: 1px solid rgba(46,125,50,0.1);
        }

        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .login-header .icon {
            font-size: 4em;
            color: #2E7D32;
            margin-bottom: 15px;
            text-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .login-header h1 {
            color: #2E7D32;
            margin-bottom: 10px;
            font-size: 2.8em;
            font-weight: 700;
        }

        .login-header p {
            color: #666;
            font-size: 1.1em;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-group .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            padding-top: 5px;
            color: #2E7D32;
            font-size: 18px;
            z-index: 1;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #333;
            font-weight: 600;
        }

        .form-group input {
            width: 100%;
            padding: 15px 15px 15px 50px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: rgba(255,255,255,0.9);
        }

        .form-group input:focus {
            outline: none;
            border-color: #2E7D32;
            box-shadow: 0 0 0 3px rgba(46,125,50,0.1);
            background: #fff;
        }

        .btn {
            display: inline-block;
            padding: 15px 40px;
            background: linear-gradient(135deg, #2E7D32 0%, #4CAF50 100%);
            color: #fff;
            text-decoration: none;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            width: 100%;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }

        .btn:hover::before {
            left: 100%;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(46,125,50,0.3);
        }

        .error-message {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            background-color: #ffebee;
            color: #c62828;
            border: 1px solid #ffcdd2;
            font-weight: 500;
        }

        .back-link {
            text-align: center;
            margin-top: 25px;
        }

        .back-link a {
            color: #2E7D32;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .back-link a:hover {
            color: #1B5E20;
            text-decoration: underline;
        }

        .demo-info {
            margin-top: 25px;
            padding: 20px;
            background: linear-gradient(135deg, #f9fbe7 0%, #e8f5e8 100%);
            border-radius: 10px;
            border-left: 5px solid #2E7D32;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .demo-info h4 {
            margin-bottom: 12px;
            color: #2E7D32;
            font-size: 1.2em;
            display: flex;
            align-items: center;
        }

        .demo-info h4 i {
            margin-right: 8px;
        }

        .demo-info p {
            margin-bottom: 8px;
            font-size: 0.95em;
            color: #555;
            font-weight: 500;
        }

        .demo-info .highlight {
            background: #fff3cd;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: monospace;
            color: #856404;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .top-bar .container {
                padding: 0 15px;
            }

            .top-bar .nav-links {
                gap: 20px;
            }

            .top-bar .nav-links a span {
                display: none;
            }
        }

        @media (max-width: 480px) {
            .login-container {
                margin: 20px;
                padding: 30px 20px;
            }

            .login-header h1 {
                font-size: 2.2em;
            }

            .top-bar .nav-links {
                gap: 15px;
            }
        }

        /* Accounting-themed animations */
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }

        .login-header .icon {
            animation: float 3s ease-in-out infinite;
        }
    </style>
</head>
<body>
    <!-- Top Navigation Bar -->
    <div class="top-bar">
        <div class="container">
            <div class="logo">
                <i class="fas fa-calculator"></i>
                <span>Great Victory Academy Accounting System</span>
            </div>
            <div class="nav-links">

                <a href="https://www.gva.edu.gh/" target="_blank">
                    <i class="fas fa-globe"></i>
                    <span>School Website</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="login-container">
            <div class="login-header">
                <div class="icon"><i class="fas fa-chart-line"></i></div>
                <h1>Accounting Portal</h1>
                <p>Secure access to financial management system</p>
            </div>

        <?php if ($error): ?>
            <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="post" action="index.php">
            <div class="form-group">
                <label for="username">Username:</label>
                <span class="input-icon"><i class="fas fa-user-tie"></i></span>
                <input type="text" id="username" name="username" required autofocus placeholder="Enter your username">
            </div>

            <div class="form-group">
                <label for="password">Password:</label>
                <span class="input-icon"><i class="fas fa-lock"></i></span>
                <input type="password" id="password" name="password" required placeholder="Enter your password">
            </div>

            <button type="submit" class="btn">
                <i class="fas fa-sign-in-alt"></i> Access Accounting System
            </button>
        </form>



        </div>
    </div>

    <script>
        // Add some interactive effects
        document.addEventListener('DOMContentLoaded', function() {
            const inputs = document.querySelectorAll('input');
            inputs.forEach(input => {
                input.addEventListener('focus', function() {
                    this.parentElement.style.transform = 'scale(1.02)';
                });
                input.addEventListener('blur', function() {
                    this.parentElement.style.transform = 'scale(1)';
                });
            });
        });
    </script>
</body>
</html>
