</main>
        </div>
    </div>

    <script>
        // Mobile menu functionality
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
            const studentSidebar = document.querySelector('.student-sidebar');

            if (mobileMenuToggle && studentSidebar) {
                mobileMenuToggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    studentSidebar.classList.toggle('open');
                });
            }

            // Close sidebar when clicking outside on mobile
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    if (!studentSidebar.contains(e.target) && !mobileMenuToggle.contains(e.target)) {
                        studentSidebar.classList.remove('open');
                    }
                }
            });

            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    studentSidebar.classList.remove('open');
                }
            });

            // Add loading animation for better UX
            const links = document.querySelectorAll('a[href]');
            links.forEach(link => {
                link.addEventListener('click', function(e) {
                    if (this.href && !this.href.includes('#')) {
                        // Add loading state
                        this.style.opacity = '0.7';
                        this.style.pointerEvents = 'none';
                    }
                });
            });
        });

        // Auto-refresh dashboard data every 5 minutes
        setInterval(function() {
            // Only refresh if on dashboard page
            if (window.location.pathname.includes('student_dashboard.php')) {
                // Could add AJAX call here to refresh dynamic data
                console.log('Dashboard auto-refresh check');
            }
        }, 300000);
    </script>
</body>
</html>
