<?php
require_once __DIR__ . '/access_control.php';
?>

<style>
    .library-sidebar {
        width: 280px;
        background: linear-gradient(135deg, #8e44ad 0%, #9b59b6 100%);
        color: #fff;
        padding: 0;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        z-index: 1000;
        font-size: 0.85rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        transition: background-color 0.3s ease;
    }

    .sidebar-header {
        padding: 25px 20px 15px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        background: rgba(255,255,255,0.05);
    }

    .library-sidebar h3 {
        margin: 0;
        color: #fff;
        font-size: 1.3em;
        font-weight: 700;
        text-align: center;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        animation: fadeInDown 0.8s ease forwards;
    }

    .sidebar-menu {
        list-style: none;
        padding: 15px 0;
        margin: 0;
    }

    .menu-item {
        margin-bottom: 5px;
    }

    .menu-link {
        color: #ecf0f1;
        text-decoration: none;
        display: flex;
        align-items: center;
        padding: 15px 20px;
        border-radius: 0;
        transition: all 0.3s ease;
        position: relative;
        border-left: 4px solid transparent;
    }

    .menu-link:hover {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        border-left-color: #f39c12;
        text-decoration: none;
    }

    .menu-link.active {
        background-color: rgba(255,255,255,0.1);
        border-left-color: #f39c12;
    }

    .menu-icon {
        font-size: 1.2em;
        margin-right: 15px;
        width: 25px;
        text-align: center;
        display: inline-block;
    }

    .menu-text {
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .logout-item .menu-link {
        margin-top: 20px;
        border-top: 1px solid rgba(255,255,255,0.1);
        padding-top: 20px;
    }

    .logout-item .menu-link:hover {
        background-color: rgba(231, 76, 60, 0.8);
        border-left-color: #e74c3c;
    }

    /* Submenu styles */
    .has-submenu .submenu {
        list-style: none;
        padding: 0;
        margin: 0;
        background-color: rgba(0,0,0,0.1);
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }

    .has-submenu .submenu-toggle {
        position: relative;
    }

    .submenu-arrow {
        margin-left: auto;
        transition: transform 0.3s ease;
    }

    .has-submenu.open .submenu-arrow {
        transform: rotate(90deg);
    }

    .has-submenu.open .submenu {
        max-height: 200px;
    }

    .submenu-link {
        color: #bdc3c7;
        text-decoration: none;
        display: block;
        padding: 10px 20px 10px 60px;
        font-size: 0.9em;
        transition: all 0.3s ease;
    }

    .submenu-link:hover {
        background-color: rgba(255,255,255,0.05);
        color: #fff;
        text-decoration: none;
    }

    .submenu-link.active {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        font-weight: 600;
    }

    /* Keyframes for animations */
    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 768px) {
        .library-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
            z-index: 999;
        }

        .library-sidebar.open {
            transform: translateX(0);
        }
    }
</style>

<div class="library-sidebar">
    <div class="sidebar-header">
        <h3>📚 Library Panel</h3>
    </div>
    <ul class="sidebar-menu">
        <li class="menu-item">
            <a href="library_dashboard.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'library_dashboard.php' ? 'active' : ''; ?>">
                <span class="menu-icon">📊</span>
                <span class="menu-text">Dashboard</span>
            </a>
        </li>
        <li class="menu-item has-submenu <?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_books.php', 'manage_borrowings.php']) ? 'open' : ''; ?>">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">📖</span>
                <span class="menu-text">Book Management</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="manage_books.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_books.php' ? 'active' : ''; ?>">Manage Books</a></li>
                <li><a href="manage_borrowings.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_borrowings.php' ? 'active' : ''; ?>">Manage Borrowings</a></li>
            </ul>
        </li>
        <li class="menu-item">
            <a href="search_books.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'search_books.php' ? 'active' : ''; ?>">
                <span class="menu-icon">🔍</span>
                <span class="menu-text">Search Books</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="collect_fines.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'collect_fines.php' ? 'active' : ''; ?>">
                <span class="menu-icon">💵</span>
                <span class="menu-text">Collect Fines</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="overdue_books.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'overdue_books.php' ? 'active' : ''; ?>">
                <span class="menu-icon">⚠️</span>
                <span class="menu-text">Overdue Books</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="library_reports.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'library_reports.php' ? 'active' : ''; ?>">
                <span class="menu-icon">📈</span>
                <span class="menu-text">Reports</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="view_profile.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_profile.php' ? 'active' : ''; ?>">
                <span class="menu-icon">👤</span>
                <span class="menu-text">Profile</span>
            </a>
        </li>
        <li class="menu-item">
            <a href="manage_settings.php" class="menu-link <?php echo basename($_SERVER['PHP_SELF']) == 'manage_settings.php' ? 'active' : ''; ?>">
                <span class="menu-icon">⚙️</span>
                <span class="menu-text">Settings</span>
            </a>
        </li>
        <li class="menu-item logout-item">
            <a href="../logout.php" class="menu-link">
                <span class="menu-icon">🚪</span>
                <span class="menu-text">Logout</span>
            </a>
        </li>
    </ul>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const submenuToggles = document.querySelectorAll('.submenu-toggle');
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const librarySidebar = document.querySelector('.library-sidebar');

        submenuToggles.forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                const parentItem = this.closest('.menu-item');
                parentItem.classList.toggle('open');
            });
        });

        if (mobileMenuToggle && librarySidebar) {
            mobileMenuToggle.addEventListener('click', function() {
                librarySidebar.classList.toggle('open');
            });
        }
    });
</script>
