<?php
require_once '../includes/session_check.php';
initAccountingSession();
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Accounting Portal - School Management System</title>
        <link rel="stylesheet" href="../css/style.css">
        <link rel="stylesheet" href="../css/admin_custom.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    </head>
<body>
    <div class="admin-container">
        <?php include 'accounting_sidebar.php'; ?>
        <div class="admin-main">
            <header class="admin-header">
                <div class="header-content">
                    <button class="mobile-menu-toggle" id="mobile-menu-toggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div class="header-info">
                        <h1><i class="fas fa-calculator"></i> Accounting Portal</h1>
                    <div class="header-meta">
                        <span class="admin-badge"><i class="fas fa-chart-line"></i> Accounts Panel</span>
                        <span class="current-date"><i class="fas fa-calendar"></i> <?php echo date('M d, Y'); ?></span>
                    </div>
                    </div>
                </div>
            </header>

            <main>
<style>
    .admin-container {
        display: flex;
        min-height: 100vh;
        background-color: #f8f9fa;
    }

    .admin-main {
        margin-left: 280px;
        flex: 1;
        padding: 20px 20px 20px 0px;
    }

    .admin-header {
         background: linear-gradient(135deg, #2E7D32 0%, #4CAF50 100%);
        padding: 15px 20px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        margin-bottom: 20px;
        margin-top: -20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .header-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .mobile-menu-toggle {
        display: none;
        background: none;
        border: none;
        font-size: 1.5em;
        color: #fff;
        cursor: pointer;
        padding: 10px;
        border-radius: 5px;
        transition: background-color 0.3s ease;
    }

    .mobile-menu-toggle:hover {
        background-color: rgba(255,255,255,0.1);
    }

    .header-info h1 {
        margin: 0 0 5px 0;
        color: #fff;
        font-size: 1.8em;
        font-weight: 600;
    }

    .header-info h1 i {
        color: #F9A825;
        margin-right: 10px;
    }

    .header-meta {
        display: flex;
        gap: 20px;
        align-items: center;
    }

    .admin-badge {
        background: linear-gradient(135deg, #F9A825 0%, #FFC107 100%);
        color: #2E7D32;
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.85em;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .current-date {
        color: #fff;
        font-size: 0.9em;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .admin-main main {
        background: white;
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-bottom: 20px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .accounting-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
        }

        .accounting-sidebar.open {
            transform: translateX(0);
        }

        .admin-main {
            margin-left: 0;
        }

        .mobile-menu-toggle {
            display: block;
        }

        .header-content {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .header-meta {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }
    }
</style>
