<?php
require_once '../config.php';

header('Content-Type: application/json');

if (!isset($_GET['student_id']) || !is_numeric($_GET['student_id'])) {
    echo json_encode([]);
    exit;
}

$student_id = (int)$_GET['student_id'];

$query = "
SELECT
    f.name AS fee_name,
    sf.amount,
    COALESCE(sf.paid_amount, 0) AS paid_amount,
    CASE
        WHEN (sf.amount - COALESCE(sf.paid_amount, 0)) < 0 THEN 0
        ELSE (sf.amount - COALESCE(sf.paid_amount, 0))
    END AS outstanding
FROM student_fees sf
JOIN fees f ON sf.fee_id = f.id
WHERE sf.student_id = ?
";

$params = [$student_id];

if (isset($_GET['fee']) && !empty($_GET['fee'])) {
    $query .= " AND sf.fee_id = ?";
    $params[] = $_GET['fee'];
}

if (isset($_GET['term']) && !empty($_GET['term'])) {
    $query .= " AND sf.term_id = ?";
    $params[] = $_GET['term'];
}

if (isset($_GET['year']) && !empty($_GET['year'])) {
    $query .= " AND f.academic_year_id = ?";
    $params[] = $_GET['year'];
}

$query .= " ORDER BY f.name ASC";

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$fees = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode($fees);
?>
